/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationReferenceDataSourceRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<AddApplicationReferenceDataSourceRequest.Builder, AddApplicationReferenceDataSourceRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(AddApplicationReferenceDataSourceRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(AddApplicationReferenceDataSourceRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<ReferenceDataSource> REFERENCE_DATA_SOURCE_FIELD = SdkField
            .<ReferenceDataSource> builder(MarshallingType.SDK_POJO).memberName("ReferenceDataSource")
            .getter(getter(AddApplicationReferenceDataSourceRequest::referenceDataSource))
            .setter(setter(Builder::referenceDataSource)).constructor(ReferenceDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, REFERENCE_DATA_SOURCE_FIELD));

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final ReferenceDataSource referenceDataSource;

    private AddApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceDataSource = builder.referenceDataSource;
    }

    /**
     * <p>
     * The name of an existing application.
     * </p>
     * 
     * @return The name of an existing application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version of the application for which you are adding the reference data source. You can use the
     * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not the
     * current version, the <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return The version of the application for which you are adding the reference data source. You can use the
     *         <a>DescribeApplication</a> operation to get the current application version. If the version specified is
     *         not the current version, the <code>ConcurrentModificationException</code> is returned.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The reference data source can be an object in your Amazon S3 bucket. Kinesis Data Analytics reads the object and
     * copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the
     * resulting in-application table that is created.
     * </p>
     * 
     * @return The reference data source can be an object in your Amazon S3 bucket. Kinesis Data Analytics reads the
     *         object and copies the data into the in-application table that is created. You provide an S3 bucket,
     *         object key name, and the resulting in-application table that is created.
     */
    public final ReferenceDataSource referenceDataSource() {
        return referenceDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(referenceDataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceRequest)) {
            return false;
        }
        AddApplicationReferenceDataSourceRequest other = (AddApplicationReferenceDataSourceRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(referenceDataSource(), other.referenceDataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationReferenceDataSourceRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId())
                .add("ReferenceDataSource", referenceDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "ReferenceDataSource":
            return Optional.ofNullable(clazz.cast(referenceDataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationReferenceDataSourceRequest, T> g) {
        return obj -> g.apply((AddApplicationReferenceDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
        /**
         * <p>
         * The name of an existing application.
         * </p>
         * 
         * @param applicationName
         *        The name of an existing application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version of the application for which you are adding the reference data source. You can use the
         * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not
         * the current version, the <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version of the application for which you are adding the reference data source. You can use the
         *        <a>DescribeApplication</a> operation to get the current application version. If the version specified
         *        is not the current version, the <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The reference data source can be an object in your Amazon S3 bucket. Kinesis Data Analytics reads the object
         * and copies the data into the in-application table that is created. You provide an S3 bucket, object key name,
         * and the resulting in-application table that is created.
         * </p>
         * 
         * @param referenceDataSource
         *        The reference data source can be an object in your Amazon S3 bucket. Kinesis Data Analytics reads the
         *        object and copies the data into the in-application table that is created. You provide an S3 bucket,
         *        object key name, and the resulting in-application table that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSource(ReferenceDataSource referenceDataSource);

        /**
         * <p>
         * The reference data source can be an object in your Amazon S3 bucket. Kinesis Data Analytics reads the object
         * and copies the data into the in-application table that is created. You provide an S3 bucket, object key name,
         * and the resulting in-application table that is created.
         * </p>
         * This is a convenience that creates an instance of the {@link ReferenceDataSource.Builder} avoiding the need
         * to create one manually via {@link ReferenceDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReferenceDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #referenceDataSource(ReferenceDataSource)}.
         * 
         * @param referenceDataSource
         *        a consumer that will call methods on {@link ReferenceDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceDataSource(ReferenceDataSource)
         */
        default Builder referenceDataSource(Consumer<ReferenceDataSource.Builder> referenceDataSource) {
            return referenceDataSource(ReferenceDataSource.builder().applyMutation(referenceDataSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private ReferenceDataSource referenceDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            referenceDataSource(model.referenceDataSource);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ReferenceDataSource.Builder getReferenceDataSource() {
            return referenceDataSource != null ? referenceDataSource.toBuilder() : null;
        }

        @Override
        public final Builder referenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        public final void setReferenceDataSource(ReferenceDataSource.BuilderImpl referenceDataSource) {
            this.referenceDataSource = referenceDataSource != null ? referenceDataSource.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationReferenceDataSourceRequest build() {
            return new AddApplicationReferenceDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
