/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationInputProcessingConfigurationResponse extends KinesisAnalyticsV2Response
        implements
        ToCopyableBuilder<AddApplicationInputProcessingConfigurationResponse.Builder, AddApplicationInputProcessingConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(AddApplicationInputProcessingConfigurationResponse::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId")
            .getter(getter(AddApplicationInputProcessingConfigurationResponse::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(AddApplicationInputProcessingConfigurationResponse::inputId))
            .setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()).build();

    private static final SdkField<InputProcessingConfigurationDescription> INPUT_PROCESSING_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<InputProcessingConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("InputProcessingConfigurationDescription")
            .getter(getter(AddApplicationInputProcessingConfigurationResponse::inputProcessingConfigurationDescription))
            .setter(setter(Builder::inputProcessingConfigurationDescription))
            .constructor(InputProcessingConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InputProcessingConfigurationDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_VERSION_ID_FIELD, INPUT_ID_FIELD, INPUT_PROCESSING_CONFIGURATION_DESCRIPTION_FIELD));

    private final String applicationARN;

    private final Long applicationVersionId;

    private final String inputId;

    private final InputProcessingConfigurationDescription inputProcessingConfigurationDescription;

    private AddApplicationInputProcessingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.inputId = builder.inputId;
        this.inputProcessingConfigurationDescription = builder.inputProcessingConfigurationDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * Provides the current application version.
     * </p>
     * 
     * @return Provides the current application version.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * <p>
     * The input ID that is associated with the application input. This is the ID that Kinesis Data Analytics assigns to
     * each input configuration that you add to your application.
     * </p>
     * 
     * @return The input ID that is associated with the application input. This is the ID that Kinesis Data Analytics
     *         assigns to each input configuration that you add to your application.
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * <p>
     * The description of the preprocessor that executes on records in this input before the application's code is run.
     * </p>
     * 
     * @return The description of the preprocessor that executes on records in this input before the application's code
     *         is run.
     */
    public final InputProcessingConfigurationDescription inputProcessingConfigurationDescription() {
        return inputProcessingConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputProcessingConfigurationResponse)) {
            return false;
        }
        AddApplicationInputProcessingConfigurationResponse other = (AddApplicationInputProcessingConfigurationResponse) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && Objects.equals(inputId(), other.inputId())
                && Objects.equals(inputProcessingConfigurationDescription(), other.inputProcessingConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationInputProcessingConfigurationResponse").add("ApplicationARN", applicationARN())
                .add("ApplicationVersionId", applicationVersionId()).add("InputId", inputId())
                .add("InputProcessingConfigurationDescription", inputProcessingConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputProcessingConfigurationDescription":
            return Optional.ofNullable(clazz.cast(inputProcessingConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationInputProcessingConfigurationResponse, T> g) {
        return obj -> g.apply((AddApplicationInputProcessingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationInputProcessingConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationARN
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * Provides the current application version.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The input ID that is associated with the application input. This is the ID that Kinesis Data Analytics
         * assigns to each input configuration that you add to your application.
         * </p>
         * 
         * @param inputId
         *        The input ID that is associated with the application input. This is the ID that Kinesis Data Analytics
         *        assigns to each input configuration that you add to your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * The description of the preprocessor that executes on records in this input before the application's code is
         * run.
         * </p>
         * 
         * @param inputProcessingConfigurationDescription
         *        The description of the preprocessor that executes on records in this input before the application's
         *        code is run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfigurationDescription(
                InputProcessingConfigurationDescription inputProcessingConfigurationDescription);

        /**
         * <p>
         * The description of the preprocessor that executes on records in this input before the application's code is
         * run.
         * </p>
         * This is a convenience that creates an instance of the {@link InputProcessingConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link InputProcessingConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputProcessingConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #inputProcessingConfigurationDescription(InputProcessingConfigurationDescription)}.
         * 
         * @param inputProcessingConfigurationDescription
         *        a consumer that will call methods on {@link InputProcessingConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfigurationDescription(InputProcessingConfigurationDescription)
         */
        default Builder inputProcessingConfigurationDescription(
                Consumer<InputProcessingConfigurationDescription.Builder> inputProcessingConfigurationDescription) {
            return inputProcessingConfigurationDescription(InputProcessingConfigurationDescription.builder()
                    .applyMutation(inputProcessingConfigurationDescription).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String applicationARN;

        private Long applicationVersionId;

        private String inputId;

        private InputProcessingConfigurationDescription inputProcessingConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputProcessingConfigurationResponse model) {
            super(model);
            applicationARN(model.applicationARN);
            applicationVersionId(model.applicationVersionId);
            inputId(model.inputId);
            inputProcessingConfigurationDescription(model.inputProcessingConfigurationDescription);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputProcessingConfigurationDescription.Builder getInputProcessingConfigurationDescription() {
            return inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationDescription(
                InputProcessingConfigurationDescription inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription;
            return this;
        }

        public final void setInputProcessingConfigurationDescription(
                InputProcessingConfigurationDescription.BuilderImpl inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription
                    .build() : null;
        }

        @Override
        public AddApplicationInputProcessingConfigurationResponse build() {
            return new AddApplicationInputProcessingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
