/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationCloudWatchLoggingOptionResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<AddApplicationCloudWatchLoggingOptionResponse.Builder, AddApplicationCloudWatchLoggingOptionResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(AddApplicationCloudWatchLoggingOptionResponse::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId")
            .getter(getter(AddApplicationCloudWatchLoggingOptionResponse::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<CloudWatchLoggingOptionDescription>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptionDescriptions")
            .getter(getter(AddApplicationCloudWatchLoggingOptionResponse::cloudWatchLoggingOptionDescriptions))
            .setter(setter(Builder::cloudWatchLoggingOptionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudWatchLoggingOptionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_VERSION_ID_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD));

    private final String applicationARN;

    private final Long applicationVersionId;

    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

    private AddApplicationCloudWatchLoggingOptionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
    }

    /**
     * <p>
     * The application's ARN.
     * </p>
     * 
     * @return The application's ARN.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * The new version ID of the Kinesis Data Analytics application. Kinesis Data Analytics updates the
     * <code>ApplicationVersionId</code> each time you change the CloudWatch logging options.
     * </p>
     * 
     * @return The new version ID of the Kinesis Data Analytics application. Kinesis Data Analytics updates the
     *         <code>ApplicationVersionId</code> each time you change the CloudWatch logging options.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * Returns true if the CloudWatchLoggingOptionDescriptions property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasCloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions != null
                && !(cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCloudWatchLoggingOptionDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
     */
    public final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCloudWatchLoggingOptionDescriptions() ? cloudWatchLoggingOptionDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationCloudWatchLoggingOptionResponse)) {
            return false;
        }
        AddApplicationCloudWatchLoggingOptionResponse other = (AddApplicationCloudWatchLoggingOptionResponse) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && hasCloudWatchLoggingOptionDescriptions() == other.hasCloudWatchLoggingOptionDescriptions()
                && Objects.equals(cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AddApplicationCloudWatchLoggingOptionResponse")
                .add("ApplicationARN", applicationARN())
                .add("ApplicationVersionId", applicationVersionId())
                .add("CloudWatchLoggingOptionDescriptions",
                        hasCloudWatchLoggingOptionDescriptions() ? cloudWatchLoggingOptionDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "CloudWatchLoggingOptionDescriptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationCloudWatchLoggingOptionResponse, T> g) {
        return obj -> g.apply((AddApplicationCloudWatchLoggingOptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionResponse> {
        /**
         * <p>
         * The application's ARN.
         * </p>
         * 
         * @param applicationARN
         *        The application's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * The new version ID of the Kinesis Data Analytics application. Kinesis Data Analytics updates the
         * <code>ApplicationVersionId</code> each time you change the CloudWatch logging options.
         * </p>
         * 
         * @param applicationVersionId
         *        The new version ID of the Kinesis Data Analytics application. Kinesis Data Analytics updates the
         *        <code>ApplicationVersionId</code> each time you change the CloudWatch logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * The descriptions of the current CloudWatch logging options for the Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CloudWatchLoggingOptionDescription>.Builder} avoiding the need to create one manually via {@link List
         * <CloudWatchLoggingOptionDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLoggingOptionDescription>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cloudWatchLoggingOptionDescriptions(List<CloudWatchLoggingOptionDescription>)}.
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        a consumer that will call methods on {@link List<CloudWatchLoggingOptionDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptionDescriptions(List<CloudWatchLoggingOptionDescription>)
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Consumer<CloudWatchLoggingOptionDescription.Builder>... cloudWatchLoggingOptionDescriptions);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String applicationARN;

        private Long applicationVersionId;

        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationCloudWatchLoggingOptionResponse model) {
            super(model);
            applicationARN(model.applicationARN);
            applicationVersionId(model.applicationVersionId);
            cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final Collection<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            if (cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return cloudWatchLoggingOptionDescriptions != null ? cloudWatchLoggingOptionDescriptions.stream()
                    .map(CloudWatchLoggingOptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions) {
            cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                Consumer<CloudWatchLoggingOptionDescription.Builder>... cloudWatchLoggingOptionDescriptions) {
            cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions)
                    .map(c -> CloudWatchLoggingOptionDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        @Override
        public AddApplicationCloudWatchLoggingOptionResponse build() {
            return new AddApplicationCloudWatchLoggingOptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
