/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParallelismConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParallelismConfigurationUpdate> {
    private static final SdkField<String> CONFIGURATION_TYPE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationTypeUpdate").getter(ParallelismConfigurationUpdate.getter(ParallelismConfigurationUpdate::configurationTypeUpdateAsString)).setter(ParallelismConfigurationUpdate.setter(Builder::configurationTypeUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTypeUpdate").build()}).build();
    private static final SdkField<Integer> PARALLELISM_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelismUpdate").getter(ParallelismConfigurationUpdate.getter(ParallelismConfigurationUpdate::parallelismUpdate)).setter(ParallelismConfigurationUpdate.setter(Builder::parallelismUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismUpdate").build()}).build();
    private static final SdkField<Integer> PARALLELISM_PER_KPU_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelismPerKPUUpdate").getter(ParallelismConfigurationUpdate.getter(ParallelismConfigurationUpdate::parallelismPerKPUUpdate)).setter(ParallelismConfigurationUpdate.setter(Builder::parallelismPerKPUUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismPerKPUUpdate").build()}).build();
    private static final SdkField<Boolean> AUTO_SCALING_ENABLED_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoScalingEnabledUpdate").getter(ParallelismConfigurationUpdate.getter(ParallelismConfigurationUpdate::autoScalingEnabledUpdate)).setter(ParallelismConfigurationUpdate.setter(Builder::autoScalingEnabledUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingEnabledUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_UPDATE_FIELD, PARALLELISM_UPDATE_FIELD, PARALLELISM_PER_KPU_UPDATE_FIELD, AUTO_SCALING_ENABLED_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationTypeUpdate;
    private final Integer parallelismUpdate;
    private final Integer parallelismPerKPUUpdate;
    private final Boolean autoScalingEnabledUpdate;

    private ParallelismConfigurationUpdate(BuilderImpl builder) {
        this.configurationTypeUpdate = builder.configurationTypeUpdate;
        this.parallelismUpdate = builder.parallelismUpdate;
        this.parallelismPerKPUUpdate = builder.parallelismPerKPUUpdate;
        this.autoScalingEnabledUpdate = builder.autoScalingEnabledUpdate;
    }

    public ConfigurationType configurationTypeUpdate() {
        return ConfigurationType.fromValue(this.configurationTypeUpdate);
    }

    public String configurationTypeUpdateAsString() {
        return this.configurationTypeUpdate;
    }

    public Integer parallelismUpdate() {
        return this.parallelismUpdate;
    }

    public Integer parallelismPerKPUUpdate() {
        return this.parallelismPerKPUUpdate;
    }

    public Boolean autoScalingEnabledUpdate() {
        return this.autoScalingEnabledUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismPerKPUUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingEnabledUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelismConfigurationUpdate)) {
            return false;
        }
        ParallelismConfigurationUpdate other = (ParallelismConfigurationUpdate)obj;
        return Objects.equals(this.configurationTypeUpdateAsString(), other.configurationTypeUpdateAsString()) && Objects.equals(this.parallelismUpdate(), other.parallelismUpdate()) && Objects.equals(this.parallelismPerKPUUpdate(), other.parallelismPerKPUUpdate()) && Objects.equals(this.autoScalingEnabledUpdate(), other.autoScalingEnabledUpdate());
    }

    public String toString() {
        return ToString.builder((String)"ParallelismConfigurationUpdate").add("ConfigurationTypeUpdate", (Object)this.configurationTypeUpdateAsString()).add("ParallelismUpdate", (Object)this.parallelismUpdate()).add("ParallelismPerKPUUpdate", (Object)this.parallelismPerKPUUpdate()).add("AutoScalingEnabledUpdate", (Object)this.autoScalingEnabledUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationTypeUpdate": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeUpdateAsString()));
            }
            case "ParallelismUpdate": {
                return Optional.ofNullable(clazz.cast(this.parallelismUpdate()));
            }
            case "ParallelismPerKPUUpdate": {
                return Optional.ofNullable(clazz.cast(this.parallelismPerKPUUpdate()));
            }
            case "AutoScalingEnabledUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoScalingEnabledUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParallelismConfigurationUpdate, T> g) {
        return obj -> g.apply((ParallelismConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationTypeUpdate;
        private Integer parallelismUpdate;
        private Integer parallelismPerKPUUpdate;
        private Boolean autoScalingEnabledUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ParallelismConfigurationUpdate model) {
            this.configurationTypeUpdate(model.configurationTypeUpdate);
            this.parallelismUpdate(model.parallelismUpdate);
            this.parallelismPerKPUUpdate(model.parallelismPerKPUUpdate);
            this.autoScalingEnabledUpdate(model.autoScalingEnabledUpdate);
        }

        public final String getConfigurationTypeUpdate() {
            return this.configurationTypeUpdate;
        }

        @Override
        public final Builder configurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
            return this;
        }

        @Override
        public final Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate) {
            this.configurationTypeUpdate(configurationTypeUpdate == null ? null : configurationTypeUpdate.toString());
            return this;
        }

        public final void setConfigurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
        }

        public final Integer getParallelismUpdate() {
            return this.parallelismUpdate;
        }

        @Override
        public final Builder parallelismUpdate(Integer parallelismUpdate) {
            this.parallelismUpdate = parallelismUpdate;
            return this;
        }

        public final void setParallelismUpdate(Integer parallelismUpdate) {
            this.parallelismUpdate = parallelismUpdate;
        }

        public final Integer getParallelismPerKPUUpdate() {
            return this.parallelismPerKPUUpdate;
        }

        @Override
        public final Builder parallelismPerKPUUpdate(Integer parallelismPerKPUUpdate) {
            this.parallelismPerKPUUpdate = parallelismPerKPUUpdate;
            return this;
        }

        public final void setParallelismPerKPUUpdate(Integer parallelismPerKPUUpdate) {
            this.parallelismPerKPUUpdate = parallelismPerKPUUpdate;
        }

        public final Boolean getAutoScalingEnabledUpdate() {
            return this.autoScalingEnabledUpdate;
        }

        @Override
        public final Builder autoScalingEnabledUpdate(Boolean autoScalingEnabledUpdate) {
            this.autoScalingEnabledUpdate = autoScalingEnabledUpdate;
            return this;
        }

        public final void setAutoScalingEnabledUpdate(Boolean autoScalingEnabledUpdate) {
            this.autoScalingEnabledUpdate = autoScalingEnabledUpdate;
        }

        public ParallelismConfigurationUpdate build() {
            return new ParallelismConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParallelismConfigurationUpdate> {
        public Builder configurationTypeUpdate(String var1);

        public Builder configurationTypeUpdate(ConfigurationType var1);

        public Builder parallelismUpdate(Integer var1);

        public Builder parallelismPerKPUUpdate(Integer var1);

        public Builder autoScalingEnabledUpdate(Boolean var1);
    }
}

