/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckpointConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CheckpointConfigurationUpdate> {
    private static final SdkField<String> CONFIGURATION_TYPE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CheckpointConfigurationUpdate.getter(CheckpointConfigurationUpdate::configurationTypeUpdateAsString)).setter(CheckpointConfigurationUpdate.setter(Builder::configurationTypeUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTypeUpdate").build()}).build();
    private static final SdkField<Boolean> CHECKPOINTING_ENABLED_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CheckpointConfigurationUpdate.getter(CheckpointConfigurationUpdate::checkpointingEnabledUpdate)).setter(CheckpointConfigurationUpdate.setter(Builder::checkpointingEnabledUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointingEnabledUpdate").build()}).build();
    private static final SdkField<Long> CHECKPOINT_INTERVAL_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CheckpointConfigurationUpdate.getter(CheckpointConfigurationUpdate::checkpointIntervalUpdate)).setter(CheckpointConfigurationUpdate.setter(Builder::checkpointIntervalUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointIntervalUpdate").build()}).build();
    private static final SdkField<Long> MIN_PAUSE_BETWEEN_CHECKPOINTS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CheckpointConfigurationUpdate.getter(CheckpointConfigurationUpdate::minPauseBetweenCheckpointsUpdate)).setter(CheckpointConfigurationUpdate.setter(Builder::minPauseBetweenCheckpointsUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinPauseBetweenCheckpointsUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_UPDATE_FIELD, CHECKPOINTING_ENABLED_UPDATE_FIELD, CHECKPOINT_INTERVAL_UPDATE_FIELD, MIN_PAUSE_BETWEEN_CHECKPOINTS_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationTypeUpdate;
    private final Boolean checkpointingEnabledUpdate;
    private final Long checkpointIntervalUpdate;
    private final Long minPauseBetweenCheckpointsUpdate;

    private CheckpointConfigurationUpdate(BuilderImpl builder) {
        this.configurationTypeUpdate = builder.configurationTypeUpdate;
        this.checkpointingEnabledUpdate = builder.checkpointingEnabledUpdate;
        this.checkpointIntervalUpdate = builder.checkpointIntervalUpdate;
        this.minPauseBetweenCheckpointsUpdate = builder.minPauseBetweenCheckpointsUpdate;
    }

    public ConfigurationType configurationTypeUpdate() {
        return ConfigurationType.fromValue(this.configurationTypeUpdate);
    }

    public String configurationTypeUpdateAsString() {
        return this.configurationTypeUpdate;
    }

    public Boolean checkpointingEnabledUpdate() {
        return this.checkpointingEnabledUpdate;
    }

    public Long checkpointIntervalUpdate() {
        return this.checkpointIntervalUpdate;
    }

    public Long minPauseBetweenCheckpointsUpdate() {
        return this.minPauseBetweenCheckpointsUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointingEnabledUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointIntervalUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minPauseBetweenCheckpointsUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointConfigurationUpdate)) {
            return false;
        }
        CheckpointConfigurationUpdate other = (CheckpointConfigurationUpdate)obj;
        return Objects.equals(this.configurationTypeUpdateAsString(), other.configurationTypeUpdateAsString()) && Objects.equals(this.checkpointingEnabledUpdate(), other.checkpointingEnabledUpdate()) && Objects.equals(this.checkpointIntervalUpdate(), other.checkpointIntervalUpdate()) && Objects.equals(this.minPauseBetweenCheckpointsUpdate(), other.minPauseBetweenCheckpointsUpdate());
    }

    public String toString() {
        return ToString.builder((String)"CheckpointConfigurationUpdate").add("ConfigurationTypeUpdate", (Object)this.configurationTypeUpdateAsString()).add("CheckpointingEnabledUpdate", (Object)this.checkpointingEnabledUpdate()).add("CheckpointIntervalUpdate", (Object)this.checkpointIntervalUpdate()).add("MinPauseBetweenCheckpointsUpdate", (Object)this.minPauseBetweenCheckpointsUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationTypeUpdate": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeUpdateAsString()));
            }
            case "CheckpointingEnabledUpdate": {
                return Optional.ofNullable(clazz.cast(this.checkpointingEnabledUpdate()));
            }
            case "CheckpointIntervalUpdate": {
                return Optional.ofNullable(clazz.cast(this.checkpointIntervalUpdate()));
            }
            case "MinPauseBetweenCheckpointsUpdate": {
                return Optional.ofNullable(clazz.cast(this.minPauseBetweenCheckpointsUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckpointConfigurationUpdate, T> g) {
        return obj -> g.apply((CheckpointConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationTypeUpdate;
        private Boolean checkpointingEnabledUpdate;
        private Long checkpointIntervalUpdate;
        private Long minPauseBetweenCheckpointsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointConfigurationUpdate model) {
            this.configurationTypeUpdate(model.configurationTypeUpdate);
            this.checkpointingEnabledUpdate(model.checkpointingEnabledUpdate);
            this.checkpointIntervalUpdate(model.checkpointIntervalUpdate);
            this.minPauseBetweenCheckpointsUpdate(model.minPauseBetweenCheckpointsUpdate);
        }

        public final String getConfigurationTypeUpdate() {
            return this.configurationTypeUpdate;
        }

        @Override
        public final Builder configurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
            return this;
        }

        @Override
        public final Builder configurationTypeUpdate(ConfigurationType configurationTypeUpdate) {
            this.configurationTypeUpdate(configurationTypeUpdate == null ? null : configurationTypeUpdate.toString());
            return this;
        }

        public final void setConfigurationTypeUpdate(String configurationTypeUpdate) {
            this.configurationTypeUpdate = configurationTypeUpdate;
        }

        public final Boolean getCheckpointingEnabledUpdate() {
            return this.checkpointingEnabledUpdate;
        }

        @Override
        public final Builder checkpointingEnabledUpdate(Boolean checkpointingEnabledUpdate) {
            this.checkpointingEnabledUpdate = checkpointingEnabledUpdate;
            return this;
        }

        public final void setCheckpointingEnabledUpdate(Boolean checkpointingEnabledUpdate) {
            this.checkpointingEnabledUpdate = checkpointingEnabledUpdate;
        }

        public final Long getCheckpointIntervalUpdate() {
            return this.checkpointIntervalUpdate;
        }

        @Override
        public final Builder checkpointIntervalUpdate(Long checkpointIntervalUpdate) {
            this.checkpointIntervalUpdate = checkpointIntervalUpdate;
            return this;
        }

        public final void setCheckpointIntervalUpdate(Long checkpointIntervalUpdate) {
            this.checkpointIntervalUpdate = checkpointIntervalUpdate;
        }

        public final Long getMinPauseBetweenCheckpointsUpdate() {
            return this.minPauseBetweenCheckpointsUpdate;
        }

        @Override
        public final Builder minPauseBetweenCheckpointsUpdate(Long minPauseBetweenCheckpointsUpdate) {
            this.minPauseBetweenCheckpointsUpdate = minPauseBetweenCheckpointsUpdate;
            return this;
        }

        public final void setMinPauseBetweenCheckpointsUpdate(Long minPauseBetweenCheckpointsUpdate) {
            this.minPauseBetweenCheckpointsUpdate = minPauseBetweenCheckpointsUpdate;
        }

        public CheckpointConfigurationUpdate build() {
            return new CheckpointConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CheckpointConfigurationUpdate> {
        public Builder configurationTypeUpdate(String var1);

        public Builder configurationTypeUpdate(ConfigurationType var1);

        public Builder checkpointingEnabledUpdate(Boolean var1);

        public Builder checkpointIntervalUpdate(Long var1);

        public Builder minPauseBetweenCheckpointsUpdate(Long var1);
    }
}

