/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkRunConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RunConfiguration> {
    private static final SdkField<FlinkRunConfiguration> FLINK_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RunConfiguration.getter(RunConfiguration::flinkRunConfiguration)).setter(RunConfiguration.setter(Builder::flinkRunConfiguration)).constructor(FlinkRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkRunConfiguration").build()}).build();
    private static final SdkField<List<SqlRunConfiguration>> SQL_RUN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RunConfiguration.getter(RunConfiguration::sqlRunConfigurations)).setter(RunConfiguration.setter(Builder::sqlRunConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlRunConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationRestoreConfiguration> APPLICATION_RESTORE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RunConfiguration.getter(RunConfiguration::applicationRestoreConfiguration)).setter(RunConfiguration.setter(Builder::applicationRestoreConfiguration)).constructor(ApplicationRestoreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRestoreConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLINK_RUN_CONFIGURATION_FIELD, SQL_RUN_CONFIGURATIONS_FIELD, APPLICATION_RESTORE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final FlinkRunConfiguration flinkRunConfiguration;
    private final List<SqlRunConfiguration> sqlRunConfigurations;
    private final ApplicationRestoreConfiguration applicationRestoreConfiguration;

    private RunConfiguration(BuilderImpl builder) {
        this.flinkRunConfiguration = builder.flinkRunConfiguration;
        this.sqlRunConfigurations = builder.sqlRunConfigurations;
        this.applicationRestoreConfiguration = builder.applicationRestoreConfiguration;
    }

    public FlinkRunConfiguration flinkRunConfiguration() {
        return this.flinkRunConfiguration;
    }

    public List<SqlRunConfiguration> sqlRunConfigurations() {
        return this.sqlRunConfigurations;
    }

    public ApplicationRestoreConfiguration applicationRestoreConfiguration() {
        return this.applicationRestoreConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flinkRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlRunConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationRestoreConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunConfiguration)) {
            return false;
        }
        RunConfiguration other = (RunConfiguration)obj;
        return Objects.equals(this.flinkRunConfiguration(), other.flinkRunConfiguration()) && Objects.equals(this.sqlRunConfigurations(), other.sqlRunConfigurations()) && Objects.equals(this.applicationRestoreConfiguration(), other.applicationRestoreConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"RunConfiguration").add("FlinkRunConfiguration", (Object)this.flinkRunConfiguration()).add("SqlRunConfigurations", this.sqlRunConfigurations()).add("ApplicationRestoreConfiguration", (Object)this.applicationRestoreConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlinkRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.flinkRunConfiguration()));
            }
            case "SqlRunConfigurations": {
                return Optional.ofNullable(clazz.cast(this.sqlRunConfigurations()));
            }
            case "ApplicationRestoreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.applicationRestoreConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunConfiguration, T> g) {
        return obj -> g.apply((RunConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FlinkRunConfiguration flinkRunConfiguration;
        private List<SqlRunConfiguration> sqlRunConfigurations = DefaultSdkAutoConstructList.getInstance();
        private ApplicationRestoreConfiguration applicationRestoreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RunConfiguration model) {
            this.flinkRunConfiguration(model.flinkRunConfiguration);
            this.sqlRunConfigurations(model.sqlRunConfigurations);
            this.applicationRestoreConfiguration(model.applicationRestoreConfiguration);
        }

        public final FlinkRunConfiguration.Builder getFlinkRunConfiguration() {
            return this.flinkRunConfiguration != null ? this.flinkRunConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder flinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration) {
            this.flinkRunConfiguration = flinkRunConfiguration;
            return this;
        }

        public final void setFlinkRunConfiguration(FlinkRunConfiguration.BuilderImpl flinkRunConfiguration) {
            this.flinkRunConfiguration = flinkRunConfiguration != null ? flinkRunConfiguration.build() : null;
        }

        public final Collection<SqlRunConfiguration.Builder> getSqlRunConfigurations() {
            return this.sqlRunConfigurations != null ? (Collection)this.sqlRunConfigurations.stream().map(SqlRunConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlRunConfigurations(Collection<SqlRunConfiguration> sqlRunConfigurations) {
            this.sqlRunConfigurations = SqlRunConfigurationsCopier.copy(sqlRunConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlRunConfigurations(SqlRunConfiguration ... sqlRunConfigurations) {
            this.sqlRunConfigurations(Arrays.asList(sqlRunConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlRunConfigurations(Consumer<SqlRunConfiguration.Builder> ... sqlRunConfigurations) {
            this.sqlRunConfigurations(Stream.of(sqlRunConfigurations).map(c -> (SqlRunConfiguration)((SqlRunConfiguration.Builder)SqlRunConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSqlRunConfigurations(Collection<SqlRunConfiguration.BuilderImpl> sqlRunConfigurations) {
            this.sqlRunConfigurations = SqlRunConfigurationsCopier.copyFromBuilder(sqlRunConfigurations);
        }

        public final ApplicationRestoreConfiguration.Builder getApplicationRestoreConfiguration() {
            return this.applicationRestoreConfiguration != null ? this.applicationRestoreConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder applicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration) {
            this.applicationRestoreConfiguration = applicationRestoreConfiguration;
            return this;
        }

        public final void setApplicationRestoreConfiguration(ApplicationRestoreConfiguration.BuilderImpl applicationRestoreConfiguration) {
            this.applicationRestoreConfiguration = applicationRestoreConfiguration != null ? applicationRestoreConfiguration.build() : null;
        }

        public RunConfiguration build() {
            return new RunConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RunConfiguration> {
        public Builder flinkRunConfiguration(FlinkRunConfiguration var1);

        default public Builder flinkRunConfiguration(Consumer<FlinkRunConfiguration.Builder> flinkRunConfiguration) {
            return this.flinkRunConfiguration((FlinkRunConfiguration)((FlinkRunConfiguration.Builder)FlinkRunConfiguration.builder().applyMutation(flinkRunConfiguration)).build());
        }

        public Builder sqlRunConfigurations(Collection<SqlRunConfiguration> var1);

        public Builder sqlRunConfigurations(SqlRunConfiguration ... var1);

        public Builder sqlRunConfigurations(Consumer<SqlRunConfiguration.Builder> ... var1);

        public Builder applicationRestoreConfiguration(ApplicationRestoreConfiguration var1);

        default public Builder applicationRestoreConfiguration(Consumer<ApplicationRestoreConfiguration.Builder> applicationRestoreConfiguration) {
            return this.applicationRestoreConfiguration((ApplicationRestoreConfiguration)((ApplicationRestoreConfiguration.Builder)ApplicationRestoreConfiguration.builder().applyMutation(applicationRestoreConfiguration)).build());
        }
    }
}

