/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationCodeConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationCodeConfigurationDescription> {
    private static final SdkField<String> CODE_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationCodeConfigurationDescription.getter(ApplicationCodeConfigurationDescription::codeContentTypeAsString)).setter(ApplicationCodeConfigurationDescription.setter(Builder::codeContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentType").build()}).build();
    private static final SdkField<CodeContentDescription> CODE_CONTENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationCodeConfigurationDescription.getter(ApplicationCodeConfigurationDescription::codeContentDescription)).setter(ApplicationCodeConfigurationDescription.setter(Builder::codeContentDescription)).constructor(CodeContentDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_CONTENT_TYPE_FIELD, CODE_CONTENT_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codeContentType;
    private final CodeContentDescription codeContentDescription;

    private ApplicationCodeConfigurationDescription(BuilderImpl builder) {
        this.codeContentType = builder.codeContentType;
        this.codeContentDescription = builder.codeContentDescription;
    }

    public CodeContentType codeContentType() {
        return CodeContentType.fromValue(this.codeContentType);
    }

    public String codeContentTypeAsString() {
        return this.codeContentType;
    }

    public CodeContentDescription codeContentDescription() {
        return this.codeContentDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeContentDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCodeConfigurationDescription)) {
            return false;
        }
        ApplicationCodeConfigurationDescription other = (ApplicationCodeConfigurationDescription)obj;
        return Objects.equals(this.codeContentTypeAsString(), other.codeContentTypeAsString()) && Objects.equals(this.codeContentDescription(), other.codeContentDescription());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationCodeConfigurationDescription").add("CodeContentType", (Object)this.codeContentTypeAsString()).add("CodeContentDescription", (Object)this.codeContentDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeContentType": {
                return Optional.ofNullable(clazz.cast(this.codeContentTypeAsString()));
            }
            case "CodeContentDescription": {
                return Optional.ofNullable(clazz.cast(this.codeContentDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCodeConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationCodeConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codeContentType;
        private CodeContentDescription codeContentDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCodeConfigurationDescription model) {
            this.codeContentType(model.codeContentType);
            this.codeContentDescription(model.codeContentDescription);
        }

        public final String getCodeContentTypeAsString() {
            return this.codeContentType;
        }

        @Override
        public final Builder codeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
            return this;
        }

        @Override
        public final Builder codeContentType(CodeContentType codeContentType) {
            this.codeContentType(codeContentType == null ? null : codeContentType.toString());
            return this;
        }

        public final void setCodeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
        }

        public final CodeContentDescription.Builder getCodeContentDescription() {
            return this.codeContentDescription != null ? this.codeContentDescription.toBuilder() : null;
        }

        @Override
        public final Builder codeContentDescription(CodeContentDescription codeContentDescription) {
            this.codeContentDescription = codeContentDescription;
            return this;
        }

        public final void setCodeContentDescription(CodeContentDescription.BuilderImpl codeContentDescription) {
            this.codeContentDescription = codeContentDescription != null ? codeContentDescription.build() : null;
        }

        public ApplicationCodeConfigurationDescription build() {
            return new ApplicationCodeConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationCodeConfigurationDescription> {
        public Builder codeContentType(String var1);

        public Builder codeContentType(CodeContentType var1);

        public Builder codeContentDescription(CodeContentDescription var1);

        default public Builder codeContentDescription(Consumer<CodeContentDescription.Builder> codeContentDescription) {
            return this.codeContentDescription((CodeContentDescription)((CodeContentDescription.Builder)CodeContentDescription.builder().applyMutation(codeContentDescription)).build());
        }
    }
}

