/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisStreamsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisStreamsInput> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisStreamsInput.getter(KinesisStreamsInput::resourceARN)).setter(KinesisStreamsInput.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceARN;

    private KinesisStreamsInput(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamsInput)) {
            return false;
        }
        KinesisStreamsInput other = (KinesisStreamsInput)obj;
        return Objects.equals(this.resourceARN(), other.resourceARN());
    }

    public String toString() {
        return ToString.builder((String)"KinesisStreamsInput").add("ResourceARN", (Object)this.resourceARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamsInput, T> g) {
        return obj -> g.apply((KinesisStreamsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamsInput model) {
            this.resourceARN(model.resourceARN);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public KinesisStreamsInput build() {
            return new KinesisStreamsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisStreamsInput> {
        public Builder resourceARN(String var1);
    }
}

