/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationDetail> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationDetail.getter(ApplicationDetail::applicationARN)).setter(ApplicationDetail.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationDetail.getter(ApplicationDetail::applicationDescription)).setter(ApplicationDetail.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationDetail.getter(ApplicationDetail::applicationName)).setter(ApplicationDetail.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationDetail.getter(ApplicationDetail::runtimeEnvironmentAsString)).setter(ApplicationDetail.setter(Builder::runtimeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationDetail.getter(ApplicationDetail::serviceExecutionRole)).setter(ApplicationDetail.setter(Builder::serviceExecutionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build()}).build();
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationDetail.getter(ApplicationDetail::applicationStatusAsString)).setter(ApplicationDetail.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionId)).setter(ApplicationDetail.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ApplicationDetail.getter(ApplicationDetail::createTimestamp)).setter(ApplicationDetail.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ApplicationDetail.getter(ApplicationDetail::lastUpdateTimestamp)).setter(ApplicationDetail.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<ApplicationConfigurationDescription> APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationDetail.getter(ApplicationDetail::applicationConfigurationDescription)).setter(ApplicationDetail.setter(Builder::applicationConfigurationDescription)).constructor(ApplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfigurationDescription").build()}).build();
    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ApplicationDetail.getter(ApplicationDetail::cloudWatchLoggingOptionDescriptions)).setter(ApplicationDetail.setter(Builder::cloudWatchLoggingOptionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_NAME_FIELD, RUNTIME_ENVIRONMENT_FIELD, SERVICE_EXECUTION_ROLE_FIELD, APPLICATION_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, CREATE_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationARN;
    private final String applicationDescription;
    private final String applicationName;
    private final String runtimeEnvironment;
    private final String serviceExecutionRole;
    private final String applicationStatus;
    private final Long applicationVersionId;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final ApplicationConfigurationDescription applicationConfigurationDescription;
    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationARN = builder.applicationARN;
        this.applicationDescription = builder.applicationDescription;
        this.applicationName = builder.applicationName;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.applicationStatus = builder.applicationStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.applicationConfigurationDescription = builder.applicationConfigurationDescription;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(this.runtimeEnvironment);
    }

    public String runtimeEnvironmentAsString() {
        return this.runtimeEnvironment;
    }

    public String serviceExecutionRole() {
        return this.serviceExecutionRole;
    }

    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public ApplicationConfigurationDescription applicationConfigurationDescription() {
        return this.applicationConfigurationDescription;
    }

    public List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail)obj;
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString()) && Objects.equals(this.serviceExecutionRole(), other.serviceExecutionRole()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.applicationConfigurationDescription(), other.applicationConfigurationDescription()) && Objects.equals(this.cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationDetail").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationDescription", (Object)this.applicationDescription()).add("ApplicationName", (Object)this.applicationName()).add("RuntimeEnvironment", (Object)this.runtimeEnvironmentAsString()).add("ServiceExecutionRole", (Object)this.serviceExecutionRole()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("ApplicationConfigurationDescription", (Object)this.applicationConfigurationDescription()).add("CloudWatchLoggingOptionDescriptions", this.cloudWatchLoggingOptionDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentAsString()));
            }
            case "ServiceExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRole()));
            }
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "ApplicationConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigurationDescription()));
            }
            case "CloudWatchLoggingOptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionDescriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDetail, T> g) {
        return obj -> g.apply((ApplicationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationARN;
        private String applicationDescription;
        private String applicationName;
        private String runtimeEnvironment;
        private String serviceExecutionRole;
        private String applicationStatus;
        private Long applicationVersionId;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private ApplicationConfigurationDescription applicationConfigurationDescription;
        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            this.applicationARN(model.applicationARN);
            this.applicationDescription(model.applicationDescription);
            this.applicationName(model.applicationName);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.serviceExecutionRole(model.serviceExecutionRole);
            this.applicationStatus(model.applicationStatus);
            this.applicationVersionId(model.applicationVersionId);
            this.createTimestamp(model.createTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.applicationConfigurationDescription(model.applicationConfigurationDescription);
            this.cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment.toString());
            return this;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        public final String getServiceExecutionRole() {
            return this.serviceExecutionRole;
        }

        @Override
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final ApplicationConfigurationDescription.Builder getApplicationConfigurationDescription() {
            return this.applicationConfigurationDescription != null ? this.applicationConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder applicationConfigurationDescription(ApplicationConfigurationDescription applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription;
            return this;
        }

        public final void setApplicationConfigurationDescription(ApplicationConfigurationDescription.BuilderImpl applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription != null ? applicationConfigurationDescription.build() : null;
        }

        public final Collection<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            return this.cloudWatchLoggingOptionDescriptions != null ? (Collection)this.cloudWatchLoggingOptionDescriptions.stream().map(CloudWatchLoggingOptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions).map(c -> (CloudWatchLoggingOptionDescription)((CloudWatchLoggingOptionDescription.Builder)CloudWatchLoggingOptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationDetail> {
        public Builder applicationARN(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationName(String var1);

        public Builder runtimeEnvironment(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        public Builder serviceExecutionRole(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder applicationVersionId(Long var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder applicationConfigurationDescription(ApplicationConfigurationDescription var1);

        default public Builder applicationConfigurationDescription(Consumer<ApplicationConfigurationDescription.Builder> applicationConfigurationDescription) {
            return this.applicationConfigurationDescription((ApplicationConfigurationDescription)((ApplicationConfigurationDescription.Builder)ApplicationConfigurationDescription.builder().applyMutation(applicationConfigurationDescription)).build());
        }

        public Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> var1);

        public Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... var1);
    }
}

