/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.services.kinesisanalytics.model.InputsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.Output;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationName)).setter(CreateApplicationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationDescription)).setter(CreateApplicationRequest.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build()}).build();
    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationRequest.getter(CreateApplicationRequest::inputs)).setter(CreateApplicationRequest.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationRequest.getter(CreateApplicationRequest::outputs)).setter(CreateApplicationRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CloudWatchLoggingOption>> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationRequest.getter(CreateApplicationRequest::cloudWatchLoggingOptions)).setter(CreateApplicationRequest.setter(Builder::cloudWatchLoggingOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationCode)).setter(CreateApplicationRequest.setter(Builder::applicationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, INPUTS_FIELD, OUTPUTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, APPLICATION_CODE_FIELD));
    private final String applicationName;
    private final String applicationDescription;
    private final List<Input> inputs;
    private final List<Output> outputs;
    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private final String applicationCode;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public String applicationCode() {
        return this.applicationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.applicationCode(), other.applicationCode());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("Inputs", this.inputs()).add("Outputs", this.outputs()).add("CloudWatchLoggingOptions", this.cloudWatchLoggingOptions()).add("ApplicationCode", (Object)this.applicationCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ApplicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ApplicationCode": {
                return Optional.ofNullable(clazz.cast(this.applicationCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions = DefaultSdkAutoConstructList.getInstance();
        private String applicationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.applicationCode(model.applicationCode);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final Collection<Input.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (Input)((Input.Builder)Input.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final Collection<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? (Collection)this.cloudWatchLoggingOptions.stream().map(CloudWatchLoggingOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder> ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Stream.of(cloudWatchLoggingOptions).map(c -> (CloudWatchLoggingOption)((CloudWatchLoggingOption.Builder)CloudWatchLoggingOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder inputs(Consumer<Input.Builder> ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... var1);

        public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder> ... var1);

        public Builder applicationCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

