/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the bucket name and object key name that stores the reference data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ReferenceDataSourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ReferenceDataSourceDescription.Builder, S3ReferenceDataSourceDescription> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARN").getter(getter(S3ReferenceDataSourceDescription::bucketARN))
            .setter(setter(Builder::bucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()).build();

    private static final SdkField<String> FILE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileKey").getter(getter(S3ReferenceDataSourceDescription::fileKey)).setter(setter(Builder::fileKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKey").build()).build();

    private static final SdkField<String> REFERENCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceRoleARN").getter(getter(S3ReferenceDataSourceDescription::referenceRoleARN))
            .setter(setter(Builder::referenceRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceRoleARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            FILE_KEY_FIELD, REFERENCE_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketARN;

    private final String fileKey;

    private final String referenceRoleARN;

    private S3ReferenceDataSourceDescription(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.referenceRoleARN = builder.referenceRoleARN;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the S3 bucket.
     */
    public final String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * Amazon S3 object key name.
     * </p>
     * 
     * @return Amazon S3 object key name.
     */
    public final String fileKey() {
        return fileKey;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to
     * populate the in-application reference table.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf
     *         to populate the in-application reference table.
     */
    public final String referenceRoleARN() {
        return referenceRoleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(referenceRoleARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceDescription)) {
            return false;
        }
        S3ReferenceDataSourceDescription other = (S3ReferenceDataSourceDescription) obj;
        return Objects.equals(bucketARN(), other.bucketARN()) && Objects.equals(fileKey(), other.fileKey())
                && Objects.equals(referenceRoleARN(), other.referenceRoleARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ReferenceDataSourceDescription").add("BucketARN", bucketARN()).add("FileKey", fileKey())
                .add("ReferenceRoleARN", referenceRoleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARN":
            return Optional.ofNullable(clazz.cast(bucketARN()));
        case "FileKey":
            return Optional.ofNullable(clazz.cast(fileKey()));
        case "ReferenceRoleARN":
            return Optional.ofNullable(clazz.cast(referenceRoleARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketARN", BUCKET_ARN_FIELD);
        map.put("FileKey", FILE_KEY_FIELD);
        map.put("ReferenceRoleARN", REFERENCE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ReferenceDataSourceDescription, T> g) {
        return obj -> g.apply((S3ReferenceDataSourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ReferenceDataSourceDescription> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARN
         *        Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * Amazon S3 object key name.
         * </p>
         * 
         * @param fileKey
         *        Amazon S3 object key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to
         * populate the in-application reference table.
         * </p>
         * 
         * @param referenceRoleARN
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your
         *        behalf to populate the in-application reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceRoleARN(String referenceRoleARN);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARN;

        private String fileKey;

        private String referenceRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceDescription model) {
            bucketARN(model.bucketARN);
            fileKey(model.fileKey);
            referenceRoleARN(model.referenceRoleARN);
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final String getFileKey() {
            return fileKey;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final String getReferenceRoleARN() {
            return referenceRoleARN;
        }

        public final void setReferenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
        }

        @Override
        public final Builder referenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
            return this;
        }

        @Override
        public S3ReferenceDataSourceDescription build() {
            return new S3ReferenceDataSourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
