/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordColumn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordColumn> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RecordColumn.getter(RecordColumn::name)).setter(RecordColumn.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mapping").getter(RecordColumn.getter(RecordColumn::mapping)).setter(RecordColumn.setter(Builder::mapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build()}).build();
    private static final SdkField<String> SQL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqlType").getter(RecordColumn.getter(RecordColumn::sqlType)).setter(RecordColumn.setter(Builder::sqlType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAPPING_FIELD, SQL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Mapping", MAPPING_FIELD);
            this.put("SqlType", SQL_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String mapping;
    private final String sqlType;

    private RecordColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.mapping = builder.mapping;
        this.sqlType = builder.sqlType;
    }

    public final String name() {
        return this.name;
    }

    public final String mapping() {
        return this.mapping;
    }

    public final String sqlType() {
        return this.sqlType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordColumn)) {
            return false;
        }
        RecordColumn other = (RecordColumn)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.mapping(), other.mapping()) && Objects.equals(this.sqlType(), other.sqlType());
    }

    public final String toString() {
        return ToString.builder((String)"RecordColumn").add("Name", (Object)this.name()).add("Mapping", (Object)this.mapping()).add("SqlType", (Object)this.sqlType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Mapping": {
                return Optional.ofNullable(clazz.cast(this.mapping()));
            }
            case "SqlType": {
                return Optional.ofNullable(clazz.cast(this.sqlType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecordColumn, T> g) {
        return obj -> g.apply((RecordColumn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String mapping;
        private String sqlType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordColumn model) {
            this.name(model.name);
            this.mapping(model.mapping);
            this.sqlType(model.sqlType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMapping() {
            return this.mapping;
        }

        public final void setMapping(String mapping) {
            this.mapping = mapping;
        }

        @Override
        public final Builder mapping(String mapping) {
            this.mapping = mapping;
            return this;
        }

        public final String getSqlType() {
            return this.sqlType;
        }

        public final void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        @Override
        public final Builder sqlType(String sqlType) {
            this.sqlType = sqlType;
            return this;
        }

        public RecordColumn build() {
            return new RecordColumn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordColumn> {
        public Builder name(String var1);

        public Builder mapping(String var1);

        public Builder sqlType(String var1);
    }
}

