/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisanalytics.DefaultKinesisAnalyticsBaseClientBuilder;
import software.amazon.awssdk.services.kinesisanalytics.DefaultKinesisAnalyticsClient;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsClient;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsClientBuilder;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.endpoints.KinesisAnalyticsEndpointProvider;

@SdkInternalApi
final class DefaultKinesisAnalyticsClientBuilder
extends DefaultKinesisAnalyticsBaseClientBuilder<KinesisAnalyticsClientBuilder, KinesisAnalyticsClient>
implements KinesisAnalyticsClientBuilder {
    DefaultKinesisAnalyticsClientBuilder() {
    }

    @Override
    public DefaultKinesisAnalyticsClientBuilder endpointProvider(KinesisAnalyticsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisAnalyticsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisAnalyticsClientBuilder.validateClientOptions(clientConfiguration);
        KinesisAnalyticsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisAnalyticsClient client = new DefaultKinesisAnalyticsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisAnalyticsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisAnalyticsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

