/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisanalytics.DefaultKinesisAnalyticsBaseClientBuilder;
import software.amazon.awssdk.services.kinesisanalytics.DefaultKinesisAnalyticsClient;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsClient;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsClientBuilder;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.endpoints.KinesisAnalyticsEndpointProvider;

@SdkInternalApi
final class DefaultKinesisAnalyticsClientBuilder
extends DefaultKinesisAnalyticsBaseClientBuilder<KinesisAnalyticsClientBuilder, KinesisAnalyticsClient>
implements KinesisAnalyticsClientBuilder {
    DefaultKinesisAnalyticsClientBuilder() {
    }

    @Override
    public DefaultKinesisAnalyticsClientBuilder endpointProvider(KinesisAnalyticsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisAnalyticsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisAnalyticsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        KinesisAnalyticsServiceClientConfiguration serviceClientConfiguration = KinesisAnalyticsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultKinesisAnalyticsClient(serviceClientConfiguration, clientConfiguration);
    }
}

