/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputStartingPosition {
    NOW("NOW"),
    TRIM_HORIZON("TRIM_HORIZON"),
    LAST_STOPPED_POINT("LAST_STOPPED_POINT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputStartingPosition> VALUE_MAP;
    private final String value;

    private InputStartingPosition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputStartingPosition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputStartingPosition> knownValues() {
        EnumSet<InputStartingPosition> knownValues = EnumSet.allOf(InputStartingPosition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputStartingPosition.class, InputStartingPosition::toString);
    }
}

