/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional mapping information when the record format uses delimiters, such as CSV. For example, the
 * following sample records use CSV format, where the records use the <i>'\n'</i> as the row delimiter and a comma (",")
 * as the column delimiter:
 * </p>
 * <p>
 * <code>"name1", "address1"</code>
 * </p>
 * <p>
 * <code>"name2", "address2"</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CSVMappingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CSVMappingParameters.Builder, CSVMappingParameters> {
    private static final SdkField<String> RECORD_ROW_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordRowDelimiter").getter(getter(CSVMappingParameters::recordRowDelimiter))
            .setter(setter(Builder::recordRowDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordRowDelimiter").build())
            .build();

    private static final SdkField<String> RECORD_COLUMN_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordColumnDelimiter").getter(getter(CSVMappingParameters::recordColumnDelimiter))
            .setter(setter(Builder::recordColumnDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordColumnDelimiter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ROW_DELIMITER_FIELD,
            RECORD_COLUMN_DELIMITER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordRowDelimiter;

    private final String recordColumnDelimiter;

    private CSVMappingParameters(BuilderImpl builder) {
        this.recordRowDelimiter = builder.recordRowDelimiter;
        this.recordColumnDelimiter = builder.recordColumnDelimiter;
    }

    /**
     * <p>
     * Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
     * </p>
     * 
     * @return Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
     */
    public final String recordRowDelimiter() {
        return recordRowDelimiter;
    }

    /**
     * <p>
     * Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
     * </p>
     * 
     * @return Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
     */
    public final String recordColumnDelimiter() {
        return recordColumnDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(recordColumnDelimiter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSVMappingParameters)) {
            return false;
        }
        CSVMappingParameters other = (CSVMappingParameters) obj;
        return Objects.equals(recordRowDelimiter(), other.recordRowDelimiter())
                && Objects.equals(recordColumnDelimiter(), other.recordColumnDelimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CSVMappingParameters").add("RecordRowDelimiter", recordRowDelimiter())
                .add("RecordColumnDelimiter", recordColumnDelimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordRowDelimiter":
            return Optional.ofNullable(clazz.cast(recordRowDelimiter()));
        case "RecordColumnDelimiter":
            return Optional.ofNullable(clazz.cast(recordColumnDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CSVMappingParameters, T> g) {
        return obj -> g.apply((CSVMappingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CSVMappingParameters> {
        /**
         * <p>
         * Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
         * </p>
         * 
         * @param recordRowDelimiter
         *        Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordRowDelimiter(String recordRowDelimiter);

        /**
         * <p>
         * Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
         * </p>
         * 
         * @param recordColumnDelimiter
         *        Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnDelimiter(String recordColumnDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String recordRowDelimiter;

        private String recordColumnDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(CSVMappingParameters model) {
            recordRowDelimiter(model.recordRowDelimiter);
            recordColumnDelimiter(model.recordColumnDelimiter);
        }

        public final String getRecordRowDelimiter() {
            return recordRowDelimiter;
        }

        public final void setRecordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
        }

        @Override
        public final Builder recordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
            return this;
        }

        public final String getRecordColumnDelimiter() {
            return recordColumnDelimiter;
        }

        public final void setRecordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
        }

        @Override
        public final Builder recordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
            return this;
        }

        @Override
        public CSVMappingParameters build() {
            return new CSVMappingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
