/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.InputConfigurationsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartApplicationRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, StartApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(StartApplicationRequest.getter(StartApplicationRequest::applicationName)).setter(StartApplicationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<List<InputConfiguration>> INPUT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputConfigurations").getter(StartApplicationRequest.getter(StartApplicationRequest::inputConfigurations)).setter(StartApplicationRequest.setter(Builder::inputConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, INPUT_CONFIGURATIONS_FIELD));
    private final String applicationName;
    private final List<InputConfiguration> inputConfigurations;

    private StartApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.inputConfigurations = builder.inputConfigurations;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final boolean hasInputConfigurations() {
        return this.inputConfigurations != null && !(this.inputConfigurations instanceof SdkAutoConstructList);
    }

    public final List<InputConfiguration> inputConfigurations() {
        return this.inputConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputConfigurations() ? this.inputConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && this.hasInputConfigurations() == other.hasInputConfigurations() && Objects.equals(this.inputConfigurations(), other.inputConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"StartApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("InputConfigurations", this.hasInputConfigurations() ? this.inputConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "InputConfigurations": {
                return Optional.ofNullable(clazz.cast(this.inputConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartApplicationRequest, T> g) {
        return obj -> g.apply((StartApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private List<InputConfiguration> inputConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.inputConfigurations(model.inputConfigurations);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final List<InputConfiguration.Builder> getInputConfigurations() {
            List<InputConfiguration.Builder> result = InputConfigurationsCopier.copyToBuilder(this.inputConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputConfigurations(Collection<InputConfiguration.BuilderImpl> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copyFromBuilder(inputConfigurations);
        }

        @Override
        @Transient
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration ... inputConfigurations) {
            this.inputConfigurations(Arrays.asList(inputConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputConfigurations(Consumer<InputConfiguration.Builder> ... inputConfigurations) {
            this.inputConfigurations(Stream.of(inputConfigurations).map(c -> (InputConfiguration)((InputConfiguration.Builder)InputConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder inputConfigurations(Collection<InputConfiguration> var1);

        public Builder inputConfigurations(InputConfiguration ... var1);

        public Builder inputConfigurations(Consumer<InputConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

