/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordFormat> {
    private static final SdkField<String> RECORD_FORMAT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordFormatType").getter(RecordFormat.getter(RecordFormat::recordFormatTypeAsString)).setter(RecordFormat.setter(Builder::recordFormatType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordFormatType").build()}).build();
    private static final SdkField<MappingParameters> MAPPING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MappingParameters").getter(RecordFormat.getter(RecordFormat::mappingParameters)).setter(RecordFormat.setter(Builder::mappingParameters)).constructor(MappingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappingParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FORMAT_TYPE_FIELD, MAPPING_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recordFormatType;
    private final MappingParameters mappingParameters;

    private RecordFormat(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
        this.mappingParameters = builder.mappingParameters;
    }

    public final RecordFormatType recordFormatType() {
        return RecordFormatType.fromValue(this.recordFormatType);
    }

    public final String recordFormatTypeAsString() {
        return this.recordFormatType;
    }

    public final MappingParameters mappingParameters() {
        return this.mappingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordFormat)) {
            return false;
        }
        RecordFormat other = (RecordFormat)obj;
        return Objects.equals(this.recordFormatTypeAsString(), other.recordFormatTypeAsString()) && Objects.equals(this.mappingParameters(), other.mappingParameters());
    }

    public final String toString() {
        return ToString.builder((String)"RecordFormat").add("RecordFormatType", (Object)this.recordFormatTypeAsString()).add("MappingParameters", (Object)this.mappingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormatType": {
                return Optional.ofNullable(clazz.cast(this.recordFormatTypeAsString()));
            }
            case "MappingParameters": {
                return Optional.ofNullable(clazz.cast(this.mappingParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordFormat, T> g) {
        return obj -> g.apply((RecordFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordFormatType;
        private MappingParameters mappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordFormat model) {
            this.recordFormatType(model.recordFormatType);
            this.mappingParameters(model.mappingParameters);
        }

        public final String getRecordFormatType() {
            return this.recordFormatType;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        @Override
        @Transient
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        @Transient
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType == null ? null : recordFormatType.toString());
            return this;
        }

        public final MappingParameters.Builder getMappingParameters() {
            return this.mappingParameters != null ? this.mappingParameters.toBuilder() : null;
        }

        public final void setMappingParameters(MappingParameters.BuilderImpl mappingParameters) {
            this.mappingParameters = mappingParameters != null ? mappingParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder mappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
            return this;
        }

        public RecordFormat build() {
            return new RecordFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordFormat> {
        public Builder recordFormatType(String var1);

        public Builder recordFormatType(RecordFormatType var1);

        public Builder mappingParameters(MappingParameters var1);

        default public Builder mappingParameters(Consumer<MappingParameters.Builder> mappingParameters) {
            return this.mappingParameters((MappingParameters)((MappingParameters.Builder)MappingParameters.builder().applyMutation(mappingParameters)).build());
        }
    }
}

