/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationInputRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, AddApplicationInputRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(AddApplicationInputRequest.getter(AddApplicationInputRequest::applicationName)).setter(AddApplicationInputRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentApplicationVersionId").getter(AddApplicationInputRequest.getter(AddApplicationInputRequest::currentApplicationVersionId)).setter(AddApplicationInputRequest.setter(Builder::currentApplicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId").build()}).build();
    private static final SdkField<Input> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(AddApplicationInputRequest.getter(AddApplicationInputRequest::input)).setter(AddApplicationInputRequest.setter(Builder::input)).constructor(Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_APPLICATION_VERSION_ID_FIELD, INPUT_FIELD));
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final Input input;

    private AddApplicationInputRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.input = builder.input;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public final Input input() {
        return this.input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputRequest)) {
            return false;
        }
        AddApplicationInputRequest other = (AddApplicationInputRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.input(), other.input());
    }

    public final String toString() {
        return ToString.builder((String)"AddApplicationInputRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentApplicationVersionId", (Object)this.currentApplicationVersionId()).add("Input", (Object)this.input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersionId()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationInputRequest, T> g) {
        return obj -> g.apply((AddApplicationInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private Input input;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.input(model.input);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final Input.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationInputRequest build() {
            return new AddApplicationInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationInputRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder input(Input var1);

        default public Builder input(Consumer<Input.Builder> input) {
            return this.input((Input)((Input.Builder)Input.builder().applyMutation(input)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

