/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutput;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutput;
import software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Output
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Output> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Output.getter(Output::name)).setter(Output.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<KinesisStreamsOutput> KINESIS_STREAMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Output.getter(Output::kinesisStreamsOutput)).setter(Output.setter(Builder::kinesisStreamsOutput)).constructor(KinesisStreamsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsOutput").build()}).build();
    private static final SdkField<KinesisFirehoseOutput> KINESIS_FIREHOSE_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Output.getter(Output::kinesisFirehoseOutput)).setter(Output.setter(Builder::kinesisFirehoseOutput)).constructor(KinesisFirehoseOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseOutput").build()}).build();
    private static final SdkField<LambdaOutput> LAMBDA_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Output.getter(Output::lambdaOutput)).setter(Output.setter(Builder::lambdaOutput)).constructor(LambdaOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaOutput").build()}).build();
    private static final SdkField<DestinationSchema> DESTINATION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Output.getter(Output::destinationSchema)).setter(Output.setter(Builder::destinationSchema)).constructor(DestinationSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, KINESIS_STREAMS_OUTPUT_FIELD, KINESIS_FIREHOSE_OUTPUT_FIELD, LAMBDA_OUTPUT_FIELD, DESTINATION_SCHEMA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final KinesisStreamsOutput kinesisStreamsOutput;
    private final KinesisFirehoseOutput kinesisFirehoseOutput;
    private final LambdaOutput lambdaOutput;
    private final DestinationSchema destinationSchema;

    private Output(BuilderImpl builder) {
        this.name = builder.name;
        this.kinesisStreamsOutput = builder.kinesisStreamsOutput;
        this.kinesisFirehoseOutput = builder.kinesisFirehoseOutput;
        this.lambdaOutput = builder.lambdaOutput;
        this.destinationSchema = builder.destinationSchema;
    }

    public String name() {
        return this.name;
    }

    public KinesisStreamsOutput kinesisStreamsOutput() {
        return this.kinesisStreamsOutput;
    }

    public KinesisFirehoseOutput kinesisFirehoseOutput() {
        return this.kinesisFirehoseOutput;
    }

    public LambdaOutput lambdaOutput() {
        return this.lambdaOutput;
    }

    public DestinationSchema destinationSchema() {
        return this.destinationSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.kinesisStreamsOutput(), other.kinesisStreamsOutput()) && Objects.equals(this.kinesisFirehoseOutput(), other.kinesisFirehoseOutput()) && Objects.equals(this.lambdaOutput(), other.lambdaOutput()) && Objects.equals(this.destinationSchema(), other.destinationSchema());
    }

    public String toString() {
        return ToString.builder((String)"Output").add("Name", (Object)this.name()).add("KinesisStreamsOutput", (Object)this.kinesisStreamsOutput()).add("KinesisFirehoseOutput", (Object)this.kinesisFirehoseOutput()).add("LambdaOutput", (Object)this.lambdaOutput()).add("DestinationSchema", (Object)this.destinationSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "KinesisStreamsOutput": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamsOutput()));
            }
            case "KinesisFirehoseOutput": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseOutput()));
            }
            case "LambdaOutput": {
                return Optional.ofNullable(clazz.cast(this.lambdaOutput()));
            }
            case "DestinationSchema": {
                return Optional.ofNullable(clazz.cast(this.destinationSchema()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private KinesisStreamsOutput kinesisStreamsOutput;
        private KinesisFirehoseOutput kinesisFirehoseOutput;
        private LambdaOutput lambdaOutput;
        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.name(model.name);
            this.kinesisStreamsOutput(model.kinesisStreamsOutput);
            this.kinesisFirehoseOutput(model.kinesisFirehoseOutput);
            this.lambdaOutput(model.lambdaOutput);
            this.destinationSchema(model.destinationSchema);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutput.Builder getKinesisStreamsOutput() {
            return this.kinesisStreamsOutput != null ? this.kinesisStreamsOutput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutput(KinesisStreamsOutput kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput;
            return this;
        }

        public final void setKinesisStreamsOutput(KinesisStreamsOutput.BuilderImpl kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput != null ? kinesisStreamsOutput.build() : null;
        }

        public final KinesisFirehoseOutput.Builder getKinesisFirehoseOutput() {
            return this.kinesisFirehoseOutput != null ? this.kinesisFirehoseOutput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutput(KinesisFirehoseOutput kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput;
            return this;
        }

        public final void setKinesisFirehoseOutput(KinesisFirehoseOutput.BuilderImpl kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput != null ? kinesisFirehoseOutput.build() : null;
        }

        public final LambdaOutput.Builder getLambdaOutput() {
            return this.lambdaOutput != null ? this.lambdaOutput.toBuilder() : null;
        }

        @Override
        public final Builder lambdaOutput(LambdaOutput lambdaOutput) {
            this.lambdaOutput = lambdaOutput;
            return this;
        }

        public final void setLambdaOutput(LambdaOutput.BuilderImpl lambdaOutput) {
            this.lambdaOutput = lambdaOutput != null ? lambdaOutput.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return this.destinationSchema != null ? this.destinationSchema.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        public Output build() {
            return new Output(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Output> {
        public Builder name(String var1);

        public Builder kinesisStreamsOutput(KinesisStreamsOutput var1);

        default public Builder kinesisStreamsOutput(Consumer<KinesisStreamsOutput.Builder> kinesisStreamsOutput) {
            return this.kinesisStreamsOutput((KinesisStreamsOutput)((KinesisStreamsOutput.Builder)KinesisStreamsOutput.builder().applyMutation(kinesisStreamsOutput)).build());
        }

        public Builder kinesisFirehoseOutput(KinesisFirehoseOutput var1);

        default public Builder kinesisFirehoseOutput(Consumer<KinesisFirehoseOutput.Builder> kinesisFirehoseOutput) {
            return this.kinesisFirehoseOutput((KinesisFirehoseOutput)((KinesisFirehoseOutput.Builder)KinesisFirehoseOutput.builder().applyMutation(kinesisFirehoseOutput)).build());
        }

        public Builder lambdaOutput(LambdaOutput var1);

        default public Builder lambdaOutput(Consumer<LambdaOutput.Builder> lambdaOutput) {
            return this.lambdaOutput((LambdaOutput)((LambdaOutput.Builder)LambdaOutput.builder().applyMutation(lambdaOutput)).build());
        }

        public Builder destinationSchema(DestinationSchema var1);

        default public Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return this.destinationSchema((DestinationSchema)((DestinationSchema.Builder)DestinationSchema.builder().applyMutation(destinationSchema)).build());
        }
    }
}

