/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputUpdate> {
    private static final SdkField<String> OUTPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputUpdate.getter(OutputUpdate::outputId)).setter(OutputUpdate.setter(Builder::outputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputId").build()}).build();
    private static final SdkField<String> NAME_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputUpdate.getter(OutputUpdate::nameUpdate)).setter(OutputUpdate.setter(Builder::nameUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameUpdate").build()}).build();
    private static final SdkField<KinesisStreamsOutputUpdate> KINESIS_STREAMS_OUTPUT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OutputUpdate.getter(OutputUpdate::kinesisStreamsOutputUpdate)).setter(OutputUpdate.setter(Builder::kinesisStreamsOutputUpdate)).constructor(KinesisStreamsOutputUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsOutputUpdate").build()}).build();
    private static final SdkField<KinesisFirehoseOutputUpdate> KINESIS_FIREHOSE_OUTPUT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OutputUpdate.getter(OutputUpdate::kinesisFirehoseOutputUpdate)).setter(OutputUpdate.setter(Builder::kinesisFirehoseOutputUpdate)).constructor(KinesisFirehoseOutputUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseOutputUpdate").build()}).build();
    private static final SdkField<LambdaOutputUpdate> LAMBDA_OUTPUT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OutputUpdate.getter(OutputUpdate::lambdaOutputUpdate)).setter(OutputUpdate.setter(Builder::lambdaOutputUpdate)).constructor(LambdaOutputUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaOutputUpdate").build()}).build();
    private static final SdkField<DestinationSchema> DESTINATION_SCHEMA_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OutputUpdate.getter(OutputUpdate::destinationSchemaUpdate)).setter(OutputUpdate.setter(Builder::destinationSchemaUpdate)).constructor(DestinationSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSchemaUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ID_FIELD, NAME_UPDATE_FIELD, KINESIS_STREAMS_OUTPUT_UPDATE_FIELD, KINESIS_FIREHOSE_OUTPUT_UPDATE_FIELD, LAMBDA_OUTPUT_UPDATE_FIELD, DESTINATION_SCHEMA_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputId;
    private final String nameUpdate;
    private final KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;
    private final KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;
    private final LambdaOutputUpdate lambdaOutputUpdate;
    private final DestinationSchema destinationSchemaUpdate;

    private OutputUpdate(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.nameUpdate = builder.nameUpdate;
        this.kinesisStreamsOutputUpdate = builder.kinesisStreamsOutputUpdate;
        this.kinesisFirehoseOutputUpdate = builder.kinesisFirehoseOutputUpdate;
        this.lambdaOutputUpdate = builder.lambdaOutputUpdate;
        this.destinationSchemaUpdate = builder.destinationSchemaUpdate;
    }

    public String outputId() {
        return this.outputId;
    }

    public String nameUpdate() {
        return this.nameUpdate;
    }

    public KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate() {
        return this.kinesisStreamsOutputUpdate;
    }

    public KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate() {
        return this.kinesisFirehoseOutputUpdate;
    }

    public LambdaOutputUpdate lambdaOutputUpdate() {
        return this.lambdaOutputUpdate;
    }

    public DestinationSchema destinationSchemaUpdate() {
        return this.destinationSchemaUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSchemaUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputUpdate)) {
            return false;
        }
        OutputUpdate other = (OutputUpdate)obj;
        return Objects.equals(this.outputId(), other.outputId()) && Objects.equals(this.nameUpdate(), other.nameUpdate()) && Objects.equals(this.kinesisStreamsOutputUpdate(), other.kinesisStreamsOutputUpdate()) && Objects.equals(this.kinesisFirehoseOutputUpdate(), other.kinesisFirehoseOutputUpdate()) && Objects.equals(this.lambdaOutputUpdate(), other.lambdaOutputUpdate()) && Objects.equals(this.destinationSchemaUpdate(), other.destinationSchemaUpdate());
    }

    public String toString() {
        return ToString.builder((String)"OutputUpdate").add("OutputId", (Object)this.outputId()).add("NameUpdate", (Object)this.nameUpdate()).add("KinesisStreamsOutputUpdate", (Object)this.kinesisStreamsOutputUpdate()).add("KinesisFirehoseOutputUpdate", (Object)this.kinesisFirehoseOutputUpdate()).add("LambdaOutputUpdate", (Object)this.lambdaOutputUpdate()).add("DestinationSchemaUpdate", (Object)this.destinationSchemaUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputId": {
                return Optional.ofNullable(clazz.cast(this.outputId()));
            }
            case "NameUpdate": {
                return Optional.ofNullable(clazz.cast(this.nameUpdate()));
            }
            case "KinesisStreamsOutputUpdate": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamsOutputUpdate()));
            }
            case "KinesisFirehoseOutputUpdate": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseOutputUpdate()));
            }
            case "LambdaOutputUpdate": {
                return Optional.ofNullable(clazz.cast(this.lambdaOutputUpdate()));
            }
            case "DestinationSchemaUpdate": {
                return Optional.ofNullable(clazz.cast(this.destinationSchemaUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputUpdate, T> g) {
        return obj -> g.apply((OutputUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputId;
        private String nameUpdate;
        private KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;
        private KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;
        private LambdaOutputUpdate lambdaOutputUpdate;
        private DestinationSchema destinationSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputUpdate model) {
            this.outputId(model.outputId);
            this.nameUpdate(model.nameUpdate);
            this.kinesisStreamsOutputUpdate(model.kinesisStreamsOutputUpdate);
            this.kinesisFirehoseOutputUpdate(model.kinesisFirehoseOutputUpdate);
            this.lambdaOutputUpdate(model.lambdaOutputUpdate);
            this.destinationSchemaUpdate(model.destinationSchemaUpdate);
        }

        public final String getOutputId() {
            return this.outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getNameUpdate() {
            return this.nameUpdate;
        }

        @Override
        public final Builder nameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
            return this;
        }

        public final void setNameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
        }

        public final KinesisStreamsOutputUpdate.Builder getKinesisStreamsOutputUpdate() {
            return this.kinesisStreamsOutputUpdate != null ? this.kinesisStreamsOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate;
            return this;
        }

        public final void setKinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate.BuilderImpl kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate != null ? kinesisStreamsOutputUpdate.build() : null;
        }

        public final KinesisFirehoseOutputUpdate.Builder getKinesisFirehoseOutputUpdate() {
            return this.kinesisFirehoseOutputUpdate != null ? this.kinesisFirehoseOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate;
            return this;
        }

        public final void setKinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate.BuilderImpl kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate != null ? kinesisFirehoseOutputUpdate.build() : null;
        }

        public final LambdaOutputUpdate.Builder getLambdaOutputUpdate() {
            return this.lambdaOutputUpdate != null ? this.lambdaOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder lambdaOutputUpdate(LambdaOutputUpdate lambdaOutputUpdate) {
            this.lambdaOutputUpdate = lambdaOutputUpdate;
            return this;
        }

        public final void setLambdaOutputUpdate(LambdaOutputUpdate.BuilderImpl lambdaOutputUpdate) {
            this.lambdaOutputUpdate = lambdaOutputUpdate != null ? lambdaOutputUpdate.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchemaUpdate() {
            return this.destinationSchemaUpdate != null ? this.destinationSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchemaUpdate(DestinationSchema destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate;
            return this;
        }

        public final void setDestinationSchemaUpdate(DestinationSchema.BuilderImpl destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate != null ? destinationSchemaUpdate.build() : null;
        }

        public OutputUpdate build() {
            return new OutputUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputUpdate> {
        public Builder outputId(String var1);

        public Builder nameUpdate(String var1);

        public Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate var1);

        default public Builder kinesisStreamsOutputUpdate(Consumer<KinesisStreamsOutputUpdate.Builder> kinesisStreamsOutputUpdate) {
            return this.kinesisStreamsOutputUpdate((KinesisStreamsOutputUpdate)((KinesisStreamsOutputUpdate.Builder)KinesisStreamsOutputUpdate.builder().applyMutation(kinesisStreamsOutputUpdate)).build());
        }

        public Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate var1);

        default public Builder kinesisFirehoseOutputUpdate(Consumer<KinesisFirehoseOutputUpdate.Builder> kinesisFirehoseOutputUpdate) {
            return this.kinesisFirehoseOutputUpdate((KinesisFirehoseOutputUpdate)((KinesisFirehoseOutputUpdate.Builder)KinesisFirehoseOutputUpdate.builder().applyMutation(kinesisFirehoseOutputUpdate)).build());
        }

        public Builder lambdaOutputUpdate(LambdaOutputUpdate var1);

        default public Builder lambdaOutputUpdate(Consumer<LambdaOutputUpdate.Builder> lambdaOutputUpdate) {
            return this.lambdaOutputUpdate((LambdaOutputUpdate)((LambdaOutputUpdate.Builder)LambdaOutputUpdate.builder().applyMutation(lambdaOutputUpdate)).build());
        }

        public Builder destinationSchemaUpdate(DestinationSchema var1);

        default public Builder destinationSchemaUpdate(Consumer<DestinationSchema.Builder> destinationSchemaUpdate) {
            return this.destinationSchemaUpdate((DestinationSchema)((DestinationSchema.Builder)DestinationSchema.builder().applyMutation(destinationSchemaUpdate)).build());
        }
    }
}

