/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.EnhancedMetrics;
import software.amazon.awssdk.services.kinesis.model.EnhancedMonitoringListCopier;
import software.amazon.awssdk.services.kinesis.model.StreamModeDetails;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;
import software.amazon.awssdk.services.kinesis.model.WarmThroughputObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamDescriptionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamDescriptionSummary> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::streamName)).setter(StreamDescriptionSummary.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::streamARN)).setter(StreamDescriptionSummary.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamStatus").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::streamStatusAsString)).setter(StreamDescriptionSummary.setter(Builder::streamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStatus").build()}).build();
    private static final SdkField<StreamModeDetails> STREAM_MODE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamModeDetails").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::streamModeDetails)).setter(StreamDescriptionSummary.setter(Builder::streamModeDetails)).constructor(StreamModeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamModeDetails").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriodHours").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::retentionPeriodHours)).setter(StreamDescriptionSummary.setter(Builder::retentionPeriodHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodHours").build()}).build();
    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StreamCreationTimestamp").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::streamCreationTimestamp)).setter(StreamDescriptionSummary.setter(Builder::streamCreationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build()}).build();
    private static final SdkField<List<EnhancedMetrics>> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnhancedMonitoring").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::enhancedMonitoring)).setter(StreamDescriptionSummary.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedMonitoring").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnhancedMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::encryptionTypeAsString)).setter(StreamDescriptionSummary.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::keyId)).setter(StreamDescriptionSummary.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Integer> OPEN_SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OpenShardCount").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::openShardCount)).setter(StreamDescriptionSummary.setter(Builder::openShardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenShardCount").build()}).build();
    private static final SdkField<Integer> CONSUMER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConsumerCount").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::consumerCount)).setter(StreamDescriptionSummary.setter(Builder::consumerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerCount").build()}).build();
    private static final SdkField<WarmThroughputObject> WARM_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmThroughput").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::warmThroughput)).setter(StreamDescriptionSummary.setter(Builder::warmThroughput)).constructor(WarmThroughputObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()}).build();
    private static final SdkField<Integer> MAX_RECORD_SIZE_IN_KIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecordSizeInKiB").getter(StreamDescriptionSummary.getter(StreamDescriptionSummary::maxRecordSizeInKiB)).setter(StreamDescriptionSummary.setter(Builder::maxRecordSizeInKiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecordSizeInKiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, STREAM_STATUS_FIELD, STREAM_MODE_DETAILS_FIELD, RETENTION_PERIOD_HOURS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD, ENHANCED_MONITORING_FIELD, ENCRYPTION_TYPE_FIELD, KEY_ID_FIELD, OPEN_SHARD_COUNT_FIELD, CONSUMER_COUNT_FIELD, WARM_THROUGHPUT_FIELD, MAX_RECORD_SIZE_IN_KIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamDescriptionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streamName;
    private final String streamARN;
    private final String streamStatus;
    private final StreamModeDetails streamModeDetails;
    private final Integer retentionPeriodHours;
    private final Instant streamCreationTimestamp;
    private final List<EnhancedMetrics> enhancedMonitoring;
    private final String encryptionType;
    private final String keyId;
    private final Integer openShardCount;
    private final Integer consumerCount;
    private final WarmThroughputObject warmThroughput;
    private final Integer maxRecordSizeInKiB;

    private StreamDescriptionSummary(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.streamModeDetails = builder.streamModeDetails;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
        this.openShardCount = builder.openShardCount;
        this.consumerCount = builder.consumerCount;
        this.warmThroughput = builder.warmThroughput;
        this.maxRecordSizeInKiB = builder.maxRecordSizeInKiB;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final StreamStatus streamStatus() {
        return StreamStatus.fromValue(this.streamStatus);
    }

    public final String streamStatusAsString() {
        return this.streamStatus;
    }

    public final StreamModeDetails streamModeDetails() {
        return this.streamModeDetails;
    }

    public final Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public final Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public final boolean hasEnhancedMonitoring() {
        return this.enhancedMonitoring != null && !(this.enhancedMonitoring instanceof SdkAutoConstructList);
    }

    public final List<EnhancedMetrics> enhancedMonitoring() {
        return this.enhancedMonitoring;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Integer openShardCount() {
        return this.openShardCount;
    }

    public final Integer consumerCount() {
        return this.consumerCount;
    }

    public final WarmThroughputObject warmThroughput() {
        return this.warmThroughput;
    }

    public final Integer maxRecordSizeInKiB() {
        return this.maxRecordSizeInKiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamModeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnhancedMonitoring() ? this.enhancedMonitoring() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.openShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecordSizeInKiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescriptionSummary)) {
            return false;
        }
        StreamDescriptionSummary other = (StreamDescriptionSummary)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.streamModeDetails(), other.streamModeDetails()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours()) && Objects.equals(this.streamCreationTimestamp(), other.streamCreationTimestamp()) && this.hasEnhancedMonitoring() == other.hasEnhancedMonitoring() && Objects.equals(this.enhancedMonitoring(), other.enhancedMonitoring()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.openShardCount(), other.openShardCount()) && Objects.equals(this.consumerCount(), other.consumerCount()) && Objects.equals(this.warmThroughput(), other.warmThroughput()) && Objects.equals(this.maxRecordSizeInKiB(), other.maxRecordSizeInKiB());
    }

    public final String toString() {
        return ToString.builder((String)"StreamDescriptionSummary").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("StreamStatus", (Object)this.streamStatusAsString()).add("StreamModeDetails", (Object)this.streamModeDetails()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).add("StreamCreationTimestamp", (Object)this.streamCreationTimestamp()).add("EnhancedMonitoring", this.hasEnhancedMonitoring() ? this.enhancedMonitoring() : null).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KeyId", (Object)this.keyId()).add("OpenShardCount", (Object)this.openShardCount()).add("ConsumerCount", (Object)this.consumerCount()).add("WarmThroughput", (Object)this.warmThroughput()).add("MaxRecordSizeInKiB", (Object)this.maxRecordSizeInKiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamStatus": {
                return Optional.ofNullable(clazz.cast(this.streamStatusAsString()));
            }
            case "StreamModeDetails": {
                return Optional.ofNullable(clazz.cast(this.streamModeDetails()));
            }
            case "RetentionPeriodHours": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodHours()));
            }
            case "StreamCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.streamCreationTimestamp()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoring()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "OpenShardCount": {
                return Optional.ofNullable(clazz.cast(this.openShardCount()));
            }
            case "ConsumerCount": {
                return Optional.ofNullable(clazz.cast(this.consumerCount()));
            }
            case "WarmThroughput": {
                return Optional.ofNullable(clazz.cast(this.warmThroughput()));
            }
            case "MaxRecordSizeInKiB": {
                return Optional.ofNullable(clazz.cast(this.maxRecordSizeInKiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamStatus", STREAM_STATUS_FIELD);
        map.put("StreamModeDetails", STREAM_MODE_DETAILS_FIELD);
        map.put("RetentionPeriodHours", RETENTION_PERIOD_HOURS_FIELD);
        map.put("StreamCreationTimestamp", STREAM_CREATION_TIMESTAMP_FIELD);
        map.put("EnhancedMonitoring", ENHANCED_MONITORING_FIELD);
        map.put("EncryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("KeyId", KEY_ID_FIELD);
        map.put("OpenShardCount", OPEN_SHARD_COUNT_FIELD);
        map.put("ConsumerCount", CONSUMER_COUNT_FIELD);
        map.put("WarmThroughput", WARM_THROUGHPUT_FIELD);
        map.put("MaxRecordSizeInKiB", MAX_RECORD_SIZE_IN_KIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamDescriptionSummary, T> g) {
        return obj -> g.apply((StreamDescriptionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String streamStatus;
        private StreamModeDetails streamModeDetails;
        private Integer retentionPeriodHours;
        private Instant streamCreationTimestamp;
        private List<EnhancedMetrics> enhancedMonitoring = DefaultSdkAutoConstructList.getInstance();
        private String encryptionType;
        private String keyId;
        private Integer openShardCount;
        private Integer consumerCount;
        private WarmThroughputObject warmThroughput;
        private Integer maxRecordSizeInKiB;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescriptionSummary model) {
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.streamStatus(model.streamStatus);
            this.streamModeDetails(model.streamModeDetails);
            this.retentionPeriodHours(model.retentionPeriodHours);
            this.streamCreationTimestamp(model.streamCreationTimestamp);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.encryptionType(model.encryptionType);
            this.keyId(model.keyId);
            this.openShardCount(model.openShardCount);
            this.consumerCount(model.consumerCount);
            this.warmThroughput(model.warmThroughput);
            this.maxRecordSizeInKiB(model.maxRecordSizeInKiB);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final StreamModeDetails.Builder getStreamModeDetails() {
            return this.streamModeDetails != null ? this.streamModeDetails.toBuilder() : null;
        }

        public final void setStreamModeDetails(StreamModeDetails.BuilderImpl streamModeDetails) {
            this.streamModeDetails = streamModeDetails != null ? streamModeDetails.build() : null;
        }

        @Override
        public final Builder streamModeDetails(StreamModeDetails streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final List<EnhancedMetrics.Builder> getEnhancedMonitoring() {
            List<EnhancedMetrics.Builder> result = EnhancedMonitoringListCopier.copyToBuilder(this.enhancedMonitoring);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnhancedMonitoring(Collection<EnhancedMetrics.BuilderImpl> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copyFromBuilder(enhancedMonitoring);
        }

        @Override
        public final Builder enhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
            this.enhancedMonitoring(Arrays.asList(enhancedMonitoring));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(Consumer<EnhancedMetrics.Builder> ... enhancedMonitoring) {
            this.enhancedMonitoring(Stream.of(enhancedMonitoring).map(c -> (EnhancedMetrics)((EnhancedMetrics.Builder)EnhancedMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Integer getOpenShardCount() {
            return this.openShardCount;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final Integer getConsumerCount() {
            return this.consumerCount;
        }

        public final void setConsumerCount(Integer consumerCount) {
            this.consumerCount = consumerCount;
        }

        @Override
        public final Builder consumerCount(Integer consumerCount) {
            this.consumerCount = consumerCount;
            return this;
        }

        public final WarmThroughputObject.Builder getWarmThroughput() {
            return this.warmThroughput != null ? this.warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(WarmThroughputObject.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(WarmThroughputObject warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        public final Integer getMaxRecordSizeInKiB() {
            return this.maxRecordSizeInKiB;
        }

        public final void setMaxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
        }

        @Override
        public final Builder maxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
            return this;
        }

        public StreamDescriptionSummary build() {
            return new StreamDescriptionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamDescriptionSummary> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder streamModeDetails(StreamModeDetails var1);

        default public Builder streamModeDetails(Consumer<StreamModeDetails.Builder> streamModeDetails) {
            return this.streamModeDetails((StreamModeDetails)((StreamModeDetails.Builder)StreamModeDetails.builder().applyMutation(streamModeDetails)).build());
        }

        public Builder retentionPeriodHours(Integer var1);

        public Builder streamCreationTimestamp(Instant var1);

        public Builder enhancedMonitoring(Collection<EnhancedMetrics> var1);

        public Builder enhancedMonitoring(EnhancedMetrics ... var1);

        public Builder enhancedMonitoring(Consumer<EnhancedMetrics.Builder> ... var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder keyId(String var1);

        public Builder openShardCount(Integer var1);

        public Builder consumerCount(Integer var1);

        public Builder warmThroughput(WarmThroughputObject var1);

        default public Builder warmThroughput(Consumer<WarmThroughputObject.Builder> warmThroughput) {
            return this.warmThroughput((WarmThroughputObject)((WarmThroughputObject.Builder)WarmThroughputObject.builder().applyMutation(warmThroughput)).build());
        }

        public Builder maxRecordSizeInKiB(Integer var1);
    }
}

