/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.StreamSummary;

public class ListStreamsPublisher
implements SdkPublisher<ListStreamsResponse> {
    private final KinesisAsyncClient client;
    private final ListStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamsPublisher(KinesisAsyncClient client, ListStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamsPublisher(KinesisAsyncClient client, ListStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> streamNames() {
        return this.flatMapIterable(response -> response.streamNames());
    }

    public final SdkPublisher<StreamSummary> streamSummaries() {
        return this.flatMapIterable(response -> response.streamSummaries());
    }

    private class ListStreamsResponseFetcher
    implements AsyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return previousPage.hasMoreStreams() != null && previousPage.hasMoreStreams() != false;
        }

        public CompletableFuture<ListStreamsResponse> nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsPublisher.this.client.listStreams(ListStreamsPublisher.this.firstRequest);
            }
            return ListStreamsPublisher.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

