/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.MinimumThroughputBillingCommitmentOutputStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MinimumThroughputBillingCommitmentOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MinimumThroughputBillingCommitmentOutput> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MinimumThroughputBillingCommitmentOutput.getter(MinimumThroughputBillingCommitmentOutput::statusAsString)).setter(MinimumThroughputBillingCommitmentOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(MinimumThroughputBillingCommitmentOutput.getter(MinimumThroughputBillingCommitmentOutput::startedAt)).setter(MinimumThroughputBillingCommitmentOutput.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(MinimumThroughputBillingCommitmentOutput.getter(MinimumThroughputBillingCommitmentOutput::endedAt)).setter(MinimumThroughputBillingCommitmentOutput.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()}).build();
    private static final SdkField<Instant> EARLIEST_ALLOWED_END_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EarliestAllowedEndAt").getter(MinimumThroughputBillingCommitmentOutput.getter(MinimumThroughputBillingCommitmentOutput::earliestAllowedEndAt)).setter(MinimumThroughputBillingCommitmentOutput.setter(Builder::earliestAllowedEndAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestAllowedEndAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, EARLIEST_ALLOWED_END_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MinimumThroughputBillingCommitmentOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant startedAt;
    private final Instant endedAt;
    private final Instant earliestAllowedEndAt;

    private MinimumThroughputBillingCommitmentOutput(BuilderImpl builder) {
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.earliestAllowedEndAt = builder.earliestAllowedEndAt;
    }

    public final MinimumThroughputBillingCommitmentOutputStatus status() {
        return MinimumThroughputBillingCommitmentOutputStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant earliestAllowedEndAt() {
        return this.earliestAllowedEndAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestAllowedEndAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinimumThroughputBillingCommitmentOutput)) {
            return false;
        }
        MinimumThroughputBillingCommitmentOutput other = (MinimumThroughputBillingCommitmentOutput)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.earliestAllowedEndAt(), other.earliestAllowedEndAt());
    }

    public final String toString() {
        return ToString.builder((String)"MinimumThroughputBillingCommitmentOutput").add("Status", (Object)this.statusAsString()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("EarliestAllowedEndAt", (Object)this.earliestAllowedEndAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "EarliestAllowedEndAt": {
                return Optional.ofNullable(clazz.cast(this.earliestAllowedEndAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("EarliestAllowedEndAt", EARLIEST_ALLOWED_END_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MinimumThroughputBillingCommitmentOutput, T> g) {
        return obj -> g.apply((MinimumThroughputBillingCommitmentOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant startedAt;
        private Instant endedAt;
        private Instant earliestAllowedEndAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MinimumThroughputBillingCommitmentOutput model) {
            this.status(model.status);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.earliestAllowedEndAt(model.earliestAllowedEndAt);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MinimumThroughputBillingCommitmentOutputStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getEarliestAllowedEndAt() {
            return this.earliestAllowedEndAt;
        }

        public final void setEarliestAllowedEndAt(Instant earliestAllowedEndAt) {
            this.earliestAllowedEndAt = earliestAllowedEndAt;
        }

        @Override
        public final Builder earliestAllowedEndAt(Instant earliestAllowedEndAt) {
            this.earliestAllowedEndAt = earliestAllowedEndAt;
            return this;
        }

        public MinimumThroughputBillingCommitmentOutput build() {
            return new MinimumThroughputBillingCommitmentOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MinimumThroughputBillingCommitmentOutput> {
        public Builder status(String var1);

        public Builder status(MinimumThroughputBillingCommitmentOutputStatus var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder earliestAllowedEndAt(Instant var1);
    }
}

