/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMaxRecordSizeRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, UpdateMaxRecordSizeRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UpdateMaxRecordSizeRequest.getter(UpdateMaxRecordSizeRequest::streamARN)).setter(UpdateMaxRecordSizeRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<Integer> MAX_RECORD_SIZE_IN_KIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecordSizeInKiB").getter(UpdateMaxRecordSizeRequest.getter(UpdateMaxRecordSizeRequest::maxRecordSizeInKiB)).setter(UpdateMaxRecordSizeRequest.setter(Builder::maxRecordSizeInKiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecordSizeInKiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, MAX_RECORD_SIZE_IN_KIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMaxRecordSizeRequest.memberNameToFieldInitializer();
    private final String streamARN;
    private final Integer maxRecordSizeInKiB;

    private UpdateMaxRecordSizeRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.maxRecordSizeInKiB = builder.maxRecordSizeInKiB;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final Integer maxRecordSizeInKiB() {
        return this.maxRecordSizeInKiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecordSizeInKiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaxRecordSizeRequest)) {
            return false;
        }
        UpdateMaxRecordSizeRequest other = (UpdateMaxRecordSizeRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.maxRecordSizeInKiB(), other.maxRecordSizeInKiB());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMaxRecordSizeRequest").add("StreamARN", (Object)this.streamARN()).add("MaxRecordSizeInKiB", (Object)this.maxRecordSizeInKiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "MaxRecordSizeInKiB": {
                return Optional.ofNullable(clazz.cast(this.maxRecordSizeInKiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("MaxRecordSizeInKiB", MAX_RECORD_SIZE_IN_KIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaxRecordSizeRequest, T> g) {
        return obj -> g.apply((UpdateMaxRecordSizeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private Integer maxRecordSizeInKiB;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaxRecordSizeRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.maxRecordSizeInKiB(model.maxRecordSizeInKiB);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final Integer getMaxRecordSizeInKiB() {
            return this.maxRecordSizeInKiB;
        }

        public final void setMaxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
        }

        @Override
        public final Builder maxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaxRecordSizeRequest build() {
            return new UpdateMaxRecordSizeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMaxRecordSizeRequest> {
        public Builder streamARN(String var1);

        public Builder maxRecordSizeInKiB(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

