/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamWarmThroughputResponse extends KinesisResponse implements
        ToCopyableBuilder<UpdateStreamWarmThroughputResponse.Builder, UpdateStreamWarmThroughputResponse> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UpdateStreamWarmThroughputResponse::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UpdateStreamWarmThroughputResponse::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<WarmThroughputObject> WARM_THROUGHPUT_FIELD = SdkField
            .<WarmThroughputObject> builder(MarshallingType.SDK_POJO).memberName("WarmThroughput")
            .getter(getter(UpdateStreamWarmThroughputResponse::warmThroughput)).setter(setter(Builder::warmThroughput))
            .constructor(WarmThroughputObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            STREAM_NAME_FIELD, WARM_THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamARN;

    private final String streamName;

    private final WarmThroughputObject warmThroughput;

    private UpdateStreamWarmThroughputResponse(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.warmThroughput = builder.warmThroughput;
    }

    /**
     * <p>
     * The ARN of the stream that was updated.
     * </p>
     * 
     * @return The ARN of the stream that was updated.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the stream that was updated.
     * </p>
     * 
     * @return The name of the stream that was updated.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * Specifies the updated warm throughput configuration for your data stream.
     * </p>
     * 
     * @return Specifies the updated warm throughput configuration for your data stream.
     */
    public final WarmThroughputObject warmThroughput() {
        return warmThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(warmThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamWarmThroughputResponse)) {
            return false;
        }
        UpdateStreamWarmThroughputResponse other = (UpdateStreamWarmThroughputResponse) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(warmThroughput(), other.warmThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStreamWarmThroughputResponse").add("StreamARN", streamARN())
                .add("StreamName", streamName()).add("WarmThroughput", warmThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "WarmThroughput":
            return Optional.ofNullable(clazz.cast(warmThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("WarmThroughput", WARM_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamWarmThroughputResponse, T> g) {
        return obj -> g.apply((UpdateStreamWarmThroughputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateStreamWarmThroughputResponse> {
        /**
         * <p>
         * The ARN of the stream that was updated.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the stream that was updated.
         * </p>
         * 
         * @param streamName
         *        The name of the stream that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * Specifies the updated warm throughput configuration for your data stream.
         * </p>
         * 
         * @param warmThroughput
         *        Specifies the updated warm throughput configuration for your data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmThroughput(WarmThroughputObject warmThroughput);

        /**
         * <p>
         * Specifies the updated warm throughput configuration for your data stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link WarmThroughputObject.Builder} avoiding
         * the need to create one manually via {@link WarmThroughputObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WarmThroughputObject.Builder#build()} is called immediately and
         * its result is passed to {@link #warmThroughput(WarmThroughputObject)}.
         * 
         * @param warmThroughput
         *        a consumer that will call methods on {@link WarmThroughputObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmThroughput(WarmThroughputObject)
         */
        default Builder warmThroughput(Consumer<WarmThroughputObject.Builder> warmThroughput) {
            return warmThroughput(WarmThroughputObject.builder().applyMutation(warmThroughput).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamARN;

        private String streamName;

        private WarmThroughputObject warmThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamWarmThroughputResponse model) {
            super(model);
            streamARN(model.streamARN);
            streamName(model.streamName);
            warmThroughput(model.warmThroughput);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final WarmThroughputObject.Builder getWarmThroughput() {
            return warmThroughput != null ? warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(WarmThroughputObject.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(WarmThroughputObject warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        @Override
        public UpdateStreamWarmThroughputResponse build() {
            return new UpdateStreamWarmThroughputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
