/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;
import software.amazon.awssdk.services.kinesis.model.ShardIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChildShard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChildShard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardId").getter(ChildShard.getter(ChildShard::shardId)).setter(ChildShard.setter(Builder::shardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()}).build();
    private static final SdkField<List<String>> PARENT_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParentShards").getter(ChildShard.getter(ChildShard::parentShards)).setter(ChildShard.setter(Builder::parentShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentShards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HashKeyRange> HASH_KEY_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HashKeyRange").getter(ChildShard.getter(ChildShard::hashKeyRange)).setter(ChildShard.setter(Builder::hashKeyRange)).constructor(HashKeyRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashKeyRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD, PARENT_SHARDS_FIELD, HASH_KEY_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shardId;
    private final List<String> parentShards;
    private final HashKeyRange hashKeyRange;

    private ChildShard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShards = builder.parentShards;
        this.hashKeyRange = builder.hashKeyRange;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final boolean hasParentShards() {
        return this.parentShards != null && !(this.parentShards instanceof SdkAutoConstructList);
    }

    public final List<String> parentShards() {
        return this.parentShards;
    }

    public final HashKeyRange hashKeyRange() {
        return this.hashKeyRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParentShards() ? this.parentShards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildShard)) {
            return false;
        }
        ChildShard other = (ChildShard)obj;
        return Objects.equals(this.shardId(), other.shardId()) && this.hasParentShards() == other.hasParentShards() && Objects.equals(this.parentShards(), other.parentShards()) && Objects.equals(this.hashKeyRange(), other.hashKeyRange());
    }

    public final String toString() {
        return ToString.builder((String)"ChildShard").add("ShardId", (Object)this.shardId()).add("ParentShards", this.hasParentShards() ? this.parentShards() : null).add("HashKeyRange", (Object)this.hashKeyRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ParentShards": {
                return Optional.ofNullable(clazz.cast(this.parentShards()));
            }
            case "HashKeyRange": {
                return Optional.ofNullable(clazz.cast(this.hashKeyRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChildShard, T> g) {
        return obj -> g.apply((ChildShard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private List<String> parentShards = DefaultSdkAutoConstructList.getInstance();
        private HashKeyRange hashKeyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ChildShard model) {
            this.shardId(model.shardId);
            this.parentShards(model.parentShards);
            this.hashKeyRange(model.hashKeyRange);
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final Collection<String> getParentShards() {
            if (this.parentShards instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parentShards;
        }

        public final void setParentShards(Collection<String> parentShards) {
            this.parentShards = ShardIdListCopier.copy(parentShards);
        }

        @Override
        public final Builder parentShards(Collection<String> parentShards) {
            this.parentShards = ShardIdListCopier.copy(parentShards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentShards(String ... parentShards) {
            this.parentShards(Arrays.asList(parentShards));
            return this;
        }

        public final HashKeyRange.Builder getHashKeyRange() {
            return this.hashKeyRange != null ? this.hashKeyRange.toBuilder() : null;
        }

        public final void setHashKeyRange(HashKeyRange.BuilderImpl hashKeyRange) {
            this.hashKeyRange = hashKeyRange != null ? hashKeyRange.build() : null;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public ChildShard build() {
            return new ChildShard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChildShard> {
        public Builder shardId(String var1);

        public Builder parentShards(Collection<String> var1);

        public Builder parentShards(String ... var1);

        public Builder hashKeyRange(HashKeyRange var1);

        default public Builder hashKeyRange(Consumer<HashKeyRange.Builder> hashKeyRange) {
            return this.hashKeyRange((HashKeyRange)((HashKeyRange.Builder)HashKeyRange.builder().applyMutation(hashKeyRange)).build());
        }
    }
}

