/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.StreamSummary;

public class ListStreamsIterable
implements SdkIterable<ListStreamsResponse> {
    private final KinesisClient client;
    private final ListStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamsIterable(KinesisClient client, ListStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public Iterator<ListStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> streamNames() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamNames() != null) {
                return response.streamNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<StreamSummary> streamSummaries() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamSummaries() != null) {
                return response.streamSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamsResponseFetcher
    implements SyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return previousPage.hasMoreStreams();
        }

        public ListStreamsResponse nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsIterable.this.client.listStreams(ListStreamsIterable.this.firstRequest);
            }
            return ListStreamsIterable.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

