/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateShardCountResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, UpdateShardCountResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UpdateShardCountResponse.getter(UpdateShardCountResponse::streamName)).setter(UpdateShardCountResponse.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<Integer> CURRENT_SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentShardCount").getter(UpdateShardCountResponse.getter(UpdateShardCountResponse::currentShardCount)).setter(UpdateShardCountResponse.setter(Builder::currentShardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentShardCount").build()}).build();
    private static final SdkField<Integer> TARGET_SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetShardCount").getter(UpdateShardCountResponse.getter(UpdateShardCountResponse::targetShardCount)).setter(UpdateShardCountResponse.setter(Builder::targetShardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetShardCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, CURRENT_SHARD_COUNT_FIELD, TARGET_SHARD_COUNT_FIELD));
    private final String streamName;
    private final Integer currentShardCount;
    private final Integer targetShardCount;

    private UpdateShardCountResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardCount = builder.currentShardCount;
        this.targetShardCount = builder.targetShardCount;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer currentShardCount() {
        return this.currentShardCount;
    }

    public final Integer targetShardCount() {
        return this.targetShardCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetShardCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountResponse)) {
            return false;
        }
        UpdateShardCountResponse other = (UpdateShardCountResponse)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.currentShardCount(), other.currentShardCount()) && Objects.equals(this.targetShardCount(), other.targetShardCount());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateShardCountResponse").add("StreamName", (Object)this.streamName()).add("CurrentShardCount", (Object)this.currentShardCount()).add("TargetShardCount", (Object)this.targetShardCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "CurrentShardCount": {
                return Optional.ofNullable(clazz.cast(this.currentShardCount()));
            }
            case "TargetShardCount": {
                return Optional.ofNullable(clazz.cast(this.targetShardCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateShardCountResponse, T> g) {
        return obj -> g.apply((UpdateShardCountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer currentShardCount;
        private Integer targetShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountResponse model) {
            super(model);
            this.streamName(model.streamName);
            this.currentShardCount(model.currentShardCount);
            this.targetShardCount(model.targetShardCount);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getCurrentShardCount() {
            return this.currentShardCount;
        }

        @Override
        public final Builder currentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
            return this;
        }

        public final void setCurrentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        @Override
        public UpdateShardCountResponse build() {
            return new UpdateShardCountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateShardCountResponse> {
        public Builder streamName(String var1);

        public Builder currentShardCount(Integer var1);

        public Builder targetShardCount(Integer var1);
    }
}

