/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegisterStreamConsumerRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").isBinary(false).build();
    private static final RegisterStreamConsumerRequestModelMarshaller INSTANCE = new RegisterStreamConsumerRequestModelMarshaller();

    private RegisterStreamConsumerRequestModelMarshaller() {
    }

    public static RegisterStreamConsumerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegisterStreamConsumerRequest registerStreamConsumerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)registerStreamConsumerRequest), (String)"registerStreamConsumerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)registerStreamConsumerRequest.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)registerStreamConsumerRequest.consumerName(), CONSUMERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

