/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceSchemaMarshaller {
    private static final MarshallingInfo<StructuredPojo> RECORDFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormat").isBinary(false).build();
    private static final MarshallingInfo<String> RECORDENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordEncoding").isBinary(false).build();
    private static final MarshallingInfo<List> RECORDCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumns").isBinary(false).build();
    private static final SourceSchemaMarshaller INSTANCE = new SourceSchemaMarshaller();

    private SourceSchemaMarshaller() {
    }

    public static SourceSchemaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceSchema sourceSchema, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceSchema, (String)"sourceSchema");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sourceSchema.recordFormat(), RECORDFORMAT_BINDING);
            protocolMarshaller.marshall((Object)sourceSchema.recordEncoding(), RECORDENCODING_BINDING);
            protocolMarshaller.marshall(sourceSchema.recordColumns(), RECORDCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

