/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.SourceSchemaUnmarshaller;

public class ReferenceDataSourceUnmarshaller
implements Unmarshaller<ReferenceDataSource, JsonUnmarshallerContext> {
    private static final ReferenceDataSourceUnmarshaller INSTANCE = new ReferenceDataSourceUnmarshaller();

    public ReferenceDataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        ReferenceDataSource.Builder referenceDataSourceBuilder = ReferenceDataSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    referenceDataSourceBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3ReferenceDataSource", targetDepth)) {
                    context.nextToken();
                    referenceDataSourceBuilder.s3ReferenceDataSource(S3ReferenceDataSourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ReferenceSchema", targetDepth)) {
                    context.nextToken();
                    referenceDataSourceBuilder.referenceSchema(SourceSchemaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ReferenceDataSource)referenceDataSourceBuilder.build();
    }

    public static ReferenceDataSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

