/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRecordsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, GetRecordsRequest> {
    private final String shardIterator;
    private final Integer limit;

    private GetRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.shardIterator = builder.shardIterator;
        this.limit = builder.limit;
    }

    public String shardIterator() {
        return this.shardIterator;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsRequest)) {
            return false;
        }
        GetRecordsRequest other = (GetRecordsRequest)((Object)obj);
        return Objects.equals(this.shardIterator(), other.shardIterator()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"GetRecordsRequest").add("ShardIterator", (Object)this.shardIterator()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardIterator": {
                return Optional.of(clazz.cast(this.shardIterator()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String shardIterator;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsRequest model) {
            this.shardIterator(model.shardIterator);
            this.limit(model.limit);
        }

        public final String getShardIterator() {
            return this.shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetRecordsRequest build() {
            return new GetRecordsRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, GetRecordsRequest> {
        public Builder shardIterator(String var1);

        public Builder limit(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

