/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.DestinationDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DestinationDescriptionMarshaller {
    private static final MarshallingInfo<String> DESTINATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedS3DestinationDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDestinationDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchDestinationDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplunkDestinationDescription").isBinary(false).build();
    private static final DestinationDescriptionMarshaller INSTANCE = new DestinationDescriptionMarshaller();

    private DestinationDescriptionMarshaller() {
    }

    public static DestinationDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DestinationDescription destinationDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)destinationDescription, (String)"destinationDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)destinationDescription.destinationId(), DESTINATIONID_BINDING);
            protocolMarshaller.marshall((Object)destinationDescription.s3DestinationDescription(), S3DESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)destinationDescription.extendedS3DestinationDescription(), EXTENDEDS3DESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)destinationDescription.redshiftDestinationDescription(), REDSHIFTDESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)destinationDescription.elasticsearchDestinationDescription(), ELASTICSEARCHDESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)destinationDescription.splunkDestinationDescription(), SPLUNKDESTINATIONDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

