/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InAppStreamNamesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism;
import software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, InputDescription> {
    private final String inputId;
    private final String namePrefix;
    private final List<String> inAppStreamNames;
    private final InputProcessingConfigurationDescription inputProcessingConfigurationDescription;
    private final KinesisStreamsInputDescription kinesisStreamsInputDescription;
    private final KinesisFirehoseInputDescription kinesisFirehoseInputDescription;
    private final SourceSchema inputSchema;
    private final InputParallelism inputParallelism;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private InputDescription(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefix = builder.namePrefix;
        this.inAppStreamNames = builder.inAppStreamNames;
        this.inputProcessingConfigurationDescription = builder.inputProcessingConfigurationDescription;
        this.kinesisStreamsInputDescription = builder.kinesisStreamsInputDescription;
        this.kinesisFirehoseInputDescription = builder.kinesisFirehoseInputDescription;
        this.inputSchema = builder.inputSchema;
        this.inputParallelism = builder.inputParallelism;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    public String inputId() {
        return this.inputId;
    }

    public String namePrefix() {
        return this.namePrefix;
    }

    public List<String> inAppStreamNames() {
        return this.inAppStreamNames;
    }

    public InputProcessingConfigurationDescription inputProcessingConfigurationDescription() {
        return this.inputProcessingConfigurationDescription;
    }

    public KinesisStreamsInputDescription kinesisStreamsInputDescription() {
        return this.kinesisStreamsInputDescription;
    }

    public KinesisFirehoseInputDescription kinesisFirehoseInputDescription() {
        return this.kinesisFirehoseInputDescription;
    }

    public SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public InputParallelism inputParallelism() {
        return this.inputParallelism;
    }

    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.inAppStreamNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsInputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseInputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStartingPositionConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDescription)) {
            return false;
        }
        InputDescription other = (InputDescription)obj;
        return Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.inAppStreamNames(), other.inAppStreamNames()) && Objects.equals(this.inputProcessingConfigurationDescription(), other.inputProcessingConfigurationDescription()) && Objects.equals(this.kinesisStreamsInputDescription(), other.kinesisStreamsInputDescription()) && Objects.equals(this.kinesisFirehoseInputDescription(), other.kinesisFirehoseInputDescription()) && Objects.equals(this.inputSchema(), other.inputSchema()) && Objects.equals(this.inputParallelism(), other.inputParallelism()) && Objects.equals(this.inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"InputDescription").add("InputId", (Object)this.inputId()).add("NamePrefix", (Object)this.namePrefix()).add("InAppStreamNames", this.inAppStreamNames()).add("InputProcessingConfigurationDescription", (Object)this.inputProcessingConfigurationDescription()).add("KinesisStreamsInputDescription", (Object)this.kinesisStreamsInputDescription()).add("KinesisFirehoseInputDescription", (Object)this.kinesisFirehoseInputDescription()).add("InputSchema", (Object)this.inputSchema()).add("InputParallelism", (Object)this.inputParallelism()).add("InputStartingPositionConfiguration", (Object)this.inputStartingPositionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputId": {
                return Optional.of(clazz.cast(this.inputId()));
            }
            case "NamePrefix": {
                return Optional.of(clazz.cast(this.namePrefix()));
            }
            case "InAppStreamNames": {
                return Optional.of(clazz.cast(this.inAppStreamNames()));
            }
            case "InputProcessingConfigurationDescription": {
                return Optional.of(clazz.cast(this.inputProcessingConfigurationDescription()));
            }
            case "KinesisStreamsInputDescription": {
                return Optional.of(clazz.cast(this.kinesisStreamsInputDescription()));
            }
            case "KinesisFirehoseInputDescription": {
                return Optional.of(clazz.cast(this.kinesisFirehoseInputDescription()));
            }
            case "InputSchema": {
                return Optional.of(clazz.cast(this.inputSchema()));
            }
            case "InputParallelism": {
                return Optional.of(clazz.cast(this.inputParallelism()));
            }
            case "InputStartingPositionConfiguration": {
                return Optional.of(clazz.cast(this.inputStartingPositionConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputId;
        private String namePrefix;
        private List<String> inAppStreamNames;
        private InputProcessingConfigurationDescription inputProcessingConfigurationDescription;
        private KinesisStreamsInputDescription kinesisStreamsInputDescription;
        private KinesisFirehoseInputDescription kinesisFirehoseInputDescription;
        private SourceSchema inputSchema;
        private InputParallelism inputParallelism;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDescription model) {
            this.inputId(model.inputId);
            this.namePrefix(model.namePrefix);
            this.inAppStreamNames(model.inAppStreamNames);
            this.inputProcessingConfigurationDescription(model.inputProcessingConfigurationDescription);
            this.kinesisStreamsInputDescription(model.kinesisStreamsInputDescription);
            this.kinesisFirehoseInputDescription(model.kinesisFirehoseInputDescription);
            this.inputSchema(model.inputSchema);
            this.inputParallelism(model.inputParallelism);
            this.inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final Collection<String> getInAppStreamNames() {
            return this.inAppStreamNames;
        }

        @Override
        public final Builder inAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppStreamNames(String ... inAppStreamNames) {
            this.inAppStreamNames(Arrays.asList(inAppStreamNames));
            return this;
        }

        public final void setInAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
        }

        public final InputProcessingConfigurationDescription.Builder getInputProcessingConfigurationDescription() {
            return this.inputProcessingConfigurationDescription != null ? this.inputProcessingConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationDescription(InputProcessingConfigurationDescription inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription;
            return this;
        }

        public final void setInputProcessingConfigurationDescription(InputProcessingConfigurationDescription.BuilderImpl inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription.build() : null;
        }

        public final KinesisStreamsInputDescription.Builder getKinesisStreamsInputDescription() {
            return this.kinesisStreamsInputDescription != null ? this.kinesisStreamsInputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
            return this;
        }

        public final void setKinesisStreamsInputDescription(KinesisStreamsInputDescription.BuilderImpl kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription != null ? kinesisStreamsInputDescription.build() : null;
        }

        public final KinesisFirehoseInputDescription.Builder getKinesisFirehoseInputDescription() {
            return this.kinesisFirehoseInputDescription != null ? this.kinesisFirehoseInputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
            return this;
        }

        public final void setKinesisFirehoseInputDescription(KinesisFirehoseInputDescription.BuilderImpl kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription != null ? kinesisFirehoseInputDescription.build() : null;
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return this.inputParallelism != null ? this.inputParallelism.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration != null ? this.inputStartingPositionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.build() : null;
        }

        public InputDescription build() {
            return new InputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputDescription> {
        public Builder inputId(String var1);

        public Builder namePrefix(String var1);

        public Builder inAppStreamNames(Collection<String> var1);

        public Builder inAppStreamNames(String ... var1);

        public Builder inputProcessingConfigurationDescription(InputProcessingConfigurationDescription var1);

        default public Builder inputProcessingConfigurationDescription(Consumer<InputProcessingConfigurationDescription.Builder> inputProcessingConfigurationDescription) {
            return this.inputProcessingConfigurationDescription((InputProcessingConfigurationDescription)((InputProcessingConfigurationDescription.Builder)InputProcessingConfigurationDescription.builder().apply(inputProcessingConfigurationDescription)).build());
        }

        public Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription var1);

        default public Builder kinesisStreamsInputDescription(Consumer<KinesisStreamsInputDescription.Builder> kinesisStreamsInputDescription) {
            return this.kinesisStreamsInputDescription((KinesisStreamsInputDescription)((KinesisStreamsInputDescription.Builder)KinesisStreamsInputDescription.builder().apply(kinesisStreamsInputDescription)).build());
        }

        public Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription var1);

        default public Builder kinesisFirehoseInputDescription(Consumer<KinesisFirehoseInputDescription.Builder> kinesisFirehoseInputDescription) {
            return this.kinesisFirehoseInputDescription((KinesisFirehoseInputDescription)((KinesisFirehoseInputDescription.Builder)KinesisFirehoseInputDescription.builder().apply(kinesisFirehoseInputDescription)).build());
        }

        public Builder inputSchema(SourceSchema var1);

        default public Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return this.inputSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().apply(inputSchema)).build());
        }

        public Builder inputParallelism(InputParallelism var1);

        default public Builder inputParallelism(Consumer<InputParallelism.Builder> inputParallelism) {
            return this.inputParallelism((InputParallelism)((InputParallelism.Builder)InputParallelism.builder().apply(inputParallelism)).build());
        }

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);

        default public Builder inputStartingPositionConfiguration(Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return this.inputStartingPositionConfiguration((InputStartingPositionConfiguration)((InputStartingPositionConfiguration.Builder)InputStartingPositionConfiguration.builder().apply(inputStartingPositionConfiguration)).build());
        }
    }
}

