/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableEnhancedMonitoringRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, EnableEnhancedMonitoringRequest> {
    private final String streamName;
    private final List<String> shardLevelMetrics;

    private EnableEnhancedMonitoringRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<MetricsName> shardLevelMetrics() {
        return TypeConverter.convert(this.shardLevelMetrics, MetricsName::fromValue);
    }

    public List<String> shardLevelMetricsStrings() {
        return this.shardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardLevelMetricsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringRequest)) {
            return false;
        }
        EnableEnhancedMonitoringRequest other = (EnableEnhancedMonitoringRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardLevelMetricsStrings(), other.shardLevelMetricsStrings());
    }

    public String toString() {
        return ToString.builder((String)"EnableEnhancedMonitoringRequest").add("StreamName", (Object)this.streamName()).add("ShardLevelMetrics", this.shardLevelMetricsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "ShardLevelMetrics": {
                return Optional.of(clazz.cast(this.shardLevelMetricsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> shardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringRequest model) {
            this.streamName(model.streamName);
            this.shardLevelMetrics(model.shardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getShardLevelMetrics() {
            return this.shardLevelMetrics;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(String ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnableEnhancedMonitoringRequest build() {
            return new EnableEnhancedMonitoringRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, EnableEnhancedMonitoringRequest> {
        public Builder streamName(String var1);

        public Builder shardLevelMetrics(Collection<String> var1);

        public Builder shardLevelMetrics(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

