/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.InputConfigurationsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartApplicationRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, StartApplicationRequest> {
    private final String applicationName;
    private final List<InputConfiguration> inputConfigurations;

    private StartApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.inputConfigurations = builder.inputConfigurations;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<InputConfiguration> inputConfigurations() {
        return this.inputConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.inputConfigurations(), other.inputConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.inputConfigurations() != null) {
            sb.append("InputConfigurations: ").append(this.inputConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "InputConfigurations": {
                return Optional.of(clazz.cast(this.inputConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private List<InputConfiguration> inputConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            this.applicationName(model.applicationName);
            this.inputConfigurations(model.inputConfigurations);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<InputConfiguration.Builder> getInputConfigurations() {
            return this.inputConfigurations != null ? (Collection)this.inputConfigurations.stream().map(InputConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration ... inputConfigurations) {
            this.inputConfigurations(Arrays.asList(inputConfigurations));
            return this;
        }

        public final void setInputConfigurations(Collection<InputConfiguration.BuilderImpl> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copyFromBuilder(inputConfigurations);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    CopyableBuilder<Builder, StartApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder inputConfigurations(Collection<InputConfiguration> var1);

        public Builder inputConfigurations(InputConfiguration ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

