/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordFormatMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordFormat
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordFormat> {
    private final String recordFormatType;
    private final MappingParameters mappingParameters;

    private RecordFormat(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
        this.mappingParameters = builder.mappingParameters;
    }

    public RecordFormatType recordFormatType() {
        return RecordFormatType.fromValue(this.recordFormatType);
    }

    public String recordFormatTypeString() {
        return this.recordFormatType;
    }

    public MappingParameters mappingParameters() {
        return this.mappingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormatTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordFormat)) {
            return false;
        }
        RecordFormat other = (RecordFormat)obj;
        return Objects.equals(this.recordFormatTypeString(), other.recordFormatTypeString()) && Objects.equals(this.mappingParameters(), other.mappingParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recordFormatTypeString() != null) {
            sb.append("RecordFormatType: ").append(this.recordFormatTypeString()).append(",");
        }
        if (this.mappingParameters() != null) {
            sb.append("MappingParameters: ").append(this.mappingParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormatType": {
                return Optional.of(clazz.cast(this.recordFormatTypeString()));
            }
            case "MappingParameters": {
                return Optional.of(clazz.cast(this.mappingParameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordFormatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordFormatType;
        private MappingParameters mappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordFormat model) {
            this.recordFormatType(model.recordFormatType);
            this.mappingParameters(model.mappingParameters);
        }

        public final String getRecordFormatType() {
            return this.recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        public final MappingParameters.Builder getMappingParameters() {
            return this.mappingParameters != null ? this.mappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder mappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
            return this;
        }

        public final void setMappingParameters(MappingParameters.BuilderImpl mappingParameters) {
            this.mappingParameters = mappingParameters != null ? mappingParameters.build() : null;
        }

        public RecordFormat build() {
            return new RecordFormat(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordFormat> {
        public Builder recordFormatType(String var1);

        public Builder recordFormatType(RecordFormatType var1);

        public Builder mappingParameters(MappingParameters var1);

        default public Builder mappingParameters(Consumer<MappingParameters.Builder> mappingParameters) {
            return this.mappingParameters((MappingParameters)((MappingParameters.Builder)MappingParameters.builder().apply(mappingParameters)).build());
        }
    }
}

