/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputDescription> {
    private final String outputId;
    private final String name;
    private final KinesisStreamsOutputDescription kinesisStreamsOutputDescription;
    private final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;
    private final DestinationSchema destinationSchema;

    private OutputDescription(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.name = builder.name;
        this.kinesisStreamsOutputDescription = builder.kinesisStreamsOutputDescription;
        this.kinesisFirehoseOutputDescription = builder.kinesisFirehoseOutputDescription;
        this.destinationSchema = builder.destinationSchema;
    }

    public String outputId() {
        return this.outputId;
    }

    public String name() {
        return this.name;
    }

    public KinesisStreamsOutputDescription kinesisStreamsOutputDescription() {
        return this.kinesisStreamsOutputDescription;
    }

    public KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription() {
        return this.kinesisFirehoseOutputDescription;
    }

    public DestinationSchema destinationSchema() {
        return this.destinationSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescription)) {
            return false;
        }
        OutputDescription other = (OutputDescription)obj;
        return Objects.equals(this.outputId(), other.outputId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.kinesisStreamsOutputDescription(), other.kinesisStreamsOutputDescription()) && Objects.equals(this.kinesisFirehoseOutputDescription(), other.kinesisFirehoseOutputDescription()) && Objects.equals(this.destinationSchema(), other.destinationSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.outputId() != null) {
            sb.append("OutputId: ").append(this.outputId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.kinesisStreamsOutputDescription() != null) {
            sb.append("KinesisStreamsOutputDescription: ").append(this.kinesisStreamsOutputDescription()).append(",");
        }
        if (this.kinesisFirehoseOutputDescription() != null) {
            sb.append("KinesisFirehoseOutputDescription: ").append(this.kinesisFirehoseOutputDescription()).append(",");
        }
        if (this.destinationSchema() != null) {
            sb.append("DestinationSchema: ").append(this.destinationSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputId": {
                return Optional.of(clazz.cast(this.outputId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "KinesisStreamsOutputDescription": {
                return Optional.of(clazz.cast(this.kinesisStreamsOutputDescription()));
            }
            case "KinesisFirehoseOutputDescription": {
                return Optional.of(clazz.cast(this.kinesisFirehoseOutputDescription()));
            }
            case "DestinationSchema": {
                return Optional.of(clazz.cast(this.destinationSchema()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputId;
        private String name;
        private KinesisStreamsOutputDescription kinesisStreamsOutputDescription;
        private KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;
        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDescription model) {
            this.outputId(model.outputId);
            this.name(model.name);
            this.kinesisStreamsOutputDescription(model.kinesisStreamsOutputDescription);
            this.kinesisFirehoseOutputDescription(model.kinesisFirehoseOutputDescription);
            this.destinationSchema(model.destinationSchema);
        }

        public final String getOutputId() {
            return this.outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutputDescription.Builder getKinesisStreamsOutputDescription() {
            return this.kinesisStreamsOutputDescription != null ? this.kinesisStreamsOutputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
            return this;
        }

        public final void setKinesisStreamsOutputDescription(KinesisStreamsOutputDescription.BuilderImpl kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription.build() : null;
        }

        public final KinesisFirehoseOutputDescription.Builder getKinesisFirehoseOutputDescription() {
            return this.kinesisFirehoseOutputDescription != null ? this.kinesisFirehoseOutputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
            return this;
        }

        public final void setKinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription.BuilderImpl kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return this.destinationSchema != null ? this.destinationSchema.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        public OutputDescription build() {
            return new OutputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputDescription> {
        public Builder outputId(String var1);

        public Builder name(String var1);

        public Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription var1);

        default public Builder kinesisStreamsOutputDescription(Consumer<KinesisStreamsOutputDescription.Builder> kinesisStreamsOutputDescription) {
            return this.kinesisStreamsOutputDescription((KinesisStreamsOutputDescription)((KinesisStreamsOutputDescription.Builder)KinesisStreamsOutputDescription.builder().apply(kinesisStreamsOutputDescription)).build());
        }

        public Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription var1);

        default public Builder kinesisFirehoseOutputDescription(Consumer<KinesisFirehoseOutputDescription.Builder> kinesisFirehoseOutputDescription) {
            return this.kinesisFirehoseOutputDescription((KinesisFirehoseOutputDescription)((KinesisFirehoseOutputDescription.Builder)KinesisFirehoseOutputDescription.builder().apply(kinesisFirehoseOutputDescription)).build());
        }

        public Builder destinationSchema(DestinationSchema var1);

        default public Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return this.destinationSchema((DestinationSchema)((DestinationSchema.Builder)DestinationSchema.builder().apply(destinationSchema)).build());
        }
    }
}

