/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteApplicationInputProcessingConfigurationRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, DeleteApplicationInputProcessingConfigurationRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String inputId;

    private DeleteApplicationInputProcessingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.inputId = builder.inputId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public String inputId() {
        return this.inputId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationInputProcessingConfigurationRequest)) {
            return false;
        }
        DeleteApplicationInputProcessingConfigurationRequest other = (DeleteApplicationInputProcessingConfigurationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.inputId(), other.inputId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.inputId() != null) {
            sb.append("InputId: ").append(this.inputId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.of(clazz.cast(this.currentApplicationVersionId()));
            }
            case "InputId": {
                return Optional.of(clazz.cast(this.inputId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String inputId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationInputProcessingConfigurationRequest model) {
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.inputId(model.inputId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationInputProcessingConfigurationRequest build() {
            return new DeleteApplicationInputProcessingConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    CopyableBuilder<Builder, DeleteApplicationInputProcessingConfigurationRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder inputId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

