/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CloudWatchLoggingOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchLoggingOption
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLoggingOption> {
    private final String logStreamARN;
    private final String roleARN;

    private CloudWatchLoggingOption(BuilderImpl builder) {
        this.logStreamARN = builder.logStreamARN;
        this.roleARN = builder.roleARN;
    }

    public String logStreamARN() {
        return this.logStreamARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOption)) {
            return false;
        }
        CloudWatchLoggingOption other = (CloudWatchLoggingOption)obj;
        return Objects.equals(this.logStreamARN(), other.logStreamARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.logStreamARN() != null) {
            sb.append("LogStreamARN: ").append(this.logStreamARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogStreamARN": {
                return Optional.of(clazz.cast(this.logStreamARN()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOption model) {
            this.logStreamARN(model.logStreamARN);
            this.roleARN(model.roleARN);
        }

        public final String getLogStreamARN() {
            return this.logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public CloudWatchLoggingOption build() {
            return new CloudWatchLoggingOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLoggingOption> {
        public Builder logStreamARN(String var1);

        public Builder roleARN(String var1);
    }
}

