/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, PutRecordResponse> {
    private final String shardId;
    private final String sequenceNumber;
    private final String encryptionType;

    private PutRecordResponse(BuilderImpl builder) {
        super(builder);
        this.shardId = builder.shardId;
        this.sequenceNumber = builder.sequenceNumber;
        this.encryptionType = builder.encryptionType;
    }

    public String shardId() {
        return this.shardId;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeString() {
        return this.encryptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse)((Object)obj);
        return Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.encryptionTypeString(), other.encryptionTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.sequenceNumber()).append(",");
        }
        if (this.encryptionTypeString() != null) {
            sb.append("EncryptionType: ").append(this.encryptionTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.of(clazz.cast(this.shardId()));
            }
            case "SequenceNumber": {
                return Optional.of(clazz.cast(this.sequenceNumber()));
            }
            case "EncryptionType": {
                return Optional.of(clazz.cast(this.encryptionTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String shardId;
        private String sequenceNumber;
        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            this.shardId(model.shardId);
            this.sequenceNumber(model.sequenceNumber);
            this.encryptionType(model.encryptionType);
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, PutRecordResponse> {
        public Builder shardId(String var1);

        public Builder sequenceNumber(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);
    }
}

