/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, PutRecordRequest> {
    private final String streamName;
    private final ByteBuffer data;
    private final String partitionKey;
    private final String explicitHashKey;
    private final String sequenceNumberForOrdering;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.data = builder.data;
        this.partitionKey = builder.partitionKey;
        this.explicitHashKey = builder.explicitHashKey;
        this.sequenceNumberForOrdering = builder.sequenceNumberForOrdering;
    }

    public String streamName() {
        return this.streamName;
    }

    public ByteBuffer data() {
        return this.data == null ? null : this.data.asReadOnlyBuffer();
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public String explicitHashKey() {
        return this.explicitHashKey;
    }

    public String sequenceNumberForOrdering() {
        return this.sequenceNumberForOrdering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumberForOrdering());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.partitionKey(), other.partitionKey()) && Objects.equals(this.explicitHashKey(), other.explicitHashKey()) && Objects.equals(this.sequenceNumberForOrdering(), other.sequenceNumberForOrdering());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.partitionKey() != null) {
            sb.append("PartitionKey: ").append(this.partitionKey()).append(",");
        }
        if (this.explicitHashKey() != null) {
            sb.append("ExplicitHashKey: ").append(this.explicitHashKey()).append(",");
        }
        if (this.sequenceNumberForOrdering() != null) {
            sb.append("SequenceNumberForOrdering: ").append(this.sequenceNumberForOrdering()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "PartitionKey": {
                return Optional.of(clazz.cast(this.partitionKey()));
            }
            case "ExplicitHashKey": {
                return Optional.of(clazz.cast(this.explicitHashKey()));
            }
            case "SequenceNumberForOrdering": {
                return Optional.of(clazz.cast(this.sequenceNumberForOrdering()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private ByteBuffer data;
        private String partitionKey;
        private String explicitHashKey;
        private String sequenceNumberForOrdering;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            this.streamName(model.streamName);
            this.data(model.data);
            this.partitionKey(model.partitionKey);
            this.explicitHashKey(model.explicitHashKey);
            this.sequenceNumberForOrdering(model.sequenceNumberForOrdering);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public final String getExplicitHashKey() {
            return this.explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        public final String getSequenceNumberForOrdering() {
            return this.sequenceNumberForOrdering;
        }

        @Override
        public final Builder sequenceNumberForOrdering(String sequenceNumberForOrdering) {
            this.sequenceNumberForOrdering = sequenceNumberForOrdering;
            return this;
        }

        public final void setSequenceNumberForOrdering(String sequenceNumberForOrdering) {
            this.sequenceNumberForOrdering = sequenceNumberForOrdering;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, PutRecordRequest> {
        public Builder streamName(String var1);

        public Builder data(ByteBuffer var1);

        public Builder partitionKey(String var1);

        public Builder explicitHashKey(String var1);

        public Builder sequenceNumberForOrdering(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

