/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetShardIteratorRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, GetShardIteratorRequest> {
    private final String streamName;
    private final String shardId;
    private final String shardIteratorType;
    private final String startingSequenceNumber;
    private final Instant timestamp;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.timestamp = builder.timestamp;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardId() {
        return this.shardId;
    }

    public ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(this.shardIteratorType);
    }

    public String shardIteratorTypeString() {
        return this.shardIteratorType;
    }

    public String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIteratorTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.shardIteratorTypeString(), other.shardIteratorTypeString()) && Objects.equals(this.startingSequenceNumber(), other.startingSequenceNumber()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.shardIteratorTypeString() != null) {
            sb.append("ShardIteratorType: ").append(this.shardIteratorTypeString()).append(",");
        }
        if (this.startingSequenceNumber() != null) {
            sb.append("StartingSequenceNumber: ").append(this.startingSequenceNumber()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "ShardId": {
                return Optional.of(clazz.cast(this.shardId()));
            }
            case "ShardIteratorType": {
                return Optional.of(clazz.cast(this.shardIteratorTypeString()));
            }
            case "StartingSequenceNumber": {
                return Optional.of(clazz.cast(this.startingSequenceNumber()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String shardId;
        private String shardIteratorType;
        private String startingSequenceNumber;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            this.streamName(model.streamName);
            this.shardId(model.shardId);
            this.shardIteratorType(model.shardIteratorType);
            this.startingSequenceNumber(model.startingSequenceNumber);
            this.timestamp(model.timestamp);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return this.shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, GetShardIteratorRequest> {
        public Builder streamName(String var1);

        public Builder shardId(String var1);

        public Builder shardIteratorType(String var1);

        public Builder shardIteratorType(ShardIteratorType var1);

        public Builder startingSequenceNumber(String var1);

        public Builder timestamp(Instant var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

