/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableEnhancedMonitoringResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
    private final String streamName;
    private final List<String> currentShardLevelMetrics;
    private final List<String> desiredShardLevelMetrics;

    private EnableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<MetricsName> currentShardLevelMetrics() {
        return TypeConverter.convert(this.currentShardLevelMetrics, MetricsName::fromValue);
    }

    public List<String> currentShardLevelMetricsStrings() {
        return this.currentShardLevelMetrics;
    }

    public List<MetricsName> desiredShardLevelMetrics() {
        return TypeConverter.convert(this.desiredShardLevelMetrics, MetricsName::fromValue);
    }

    public List<String> desiredShardLevelMetricsStrings() {
        return this.desiredShardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentShardLevelMetricsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredShardLevelMetricsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringResponse)) {
            return false;
        }
        EnableEnhancedMonitoringResponse other = (EnableEnhancedMonitoringResponse)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.currentShardLevelMetricsStrings(), other.currentShardLevelMetricsStrings()) && Objects.equals(this.desiredShardLevelMetricsStrings(), other.desiredShardLevelMetricsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.currentShardLevelMetricsStrings() != null) {
            sb.append("CurrentShardLevelMetrics: ").append(this.currentShardLevelMetricsStrings()).append(",");
        }
        if (this.desiredShardLevelMetricsStrings() != null) {
            sb.append("DesiredShardLevelMetrics: ").append(this.desiredShardLevelMetricsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "CurrentShardLevelMetrics": {
                return Optional.of(clazz.cast(this.currentShardLevelMetricsStrings()));
            }
            case "DesiredShardLevelMetrics": {
                return Optional.of(clazz.cast(this.desiredShardLevelMetricsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> currentShardLevelMetrics;
        private List<String> desiredShardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringResponse model) {
            this.streamName(model.streamName);
            this.currentShardLevelMetrics(model.currentShardLevelMetrics);
            this.desiredShardLevelMetrics(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            return this.currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(String ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            return this.desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(String ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public EnableEnhancedMonitoringResponse build() {
            return new EnableEnhancedMonitoringResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
        public Builder streamName(String var1);

        public Builder currentShardLevelMetrics(Collection<String> var1);

        public Builder currentShardLevelMetrics(String ... var1);

        public Builder desiredShardLevelMetrics(Collection<String> var1);

        public Builder desiredShardLevelMetrics(String ... var1);
    }
}

