/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DescribeStreamRequest> {
    private final String streamName;
    private final Integer limit;
    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartShardId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartShardId(), other.exclusiveStartShardId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.exclusiveStartShardId() != null) {
            sb.append("ExclusiveStartShardId: ").append(this.exclusiveStartShardId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartShardId": {
                return Optional.of(clazz.cast(this.exclusiveStartShardId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer limit;
        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            this.streamName(model.streamName);
            this.limit(model.limit);
            this.exclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, DescribeStreamRequest> {
        public Builder streamName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartShardId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

