/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationUpdate;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDestinationRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, UpdateDestinationRequest> {
    private final String deliveryStreamName;
    private final String currentDeliveryStreamVersionId;
    private final String destinationId;
    private final S3DestinationUpdate s3DestinationUpdate;
    private final ExtendedS3DestinationUpdate extendedS3DestinationUpdate;
    private final RedshiftDestinationUpdate redshiftDestinationUpdate;
    private final ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;
    private final SplunkDestinationUpdate splunkDestinationUpdate;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.currentDeliveryStreamVersionId = builder.currentDeliveryStreamVersionId;
        this.destinationId = builder.destinationId;
        this.s3DestinationUpdate = builder.s3DestinationUpdate;
        this.extendedS3DestinationUpdate = builder.extendedS3DestinationUpdate;
        this.redshiftDestinationUpdate = builder.redshiftDestinationUpdate;
        this.elasticsearchDestinationUpdate = builder.elasticsearchDestinationUpdate;
        this.splunkDestinationUpdate = builder.splunkDestinationUpdate;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String currentDeliveryStreamVersionId() {
        return this.currentDeliveryStreamVersionId;
    }

    public String destinationId() {
        return this.destinationId;
    }

    public S3DestinationUpdate s3DestinationUpdate() {
        return this.s3DestinationUpdate;
    }

    public ExtendedS3DestinationUpdate extendedS3DestinationUpdate() {
        return this.extendedS3DestinationUpdate;
    }

    public RedshiftDestinationUpdate redshiftDestinationUpdate() {
        return this.redshiftDestinationUpdate;
    }

    public ElasticsearchDestinationUpdate elasticsearchDestinationUpdate() {
        return this.elasticsearchDestinationUpdate;
    }

    public SplunkDestinationUpdate splunkDestinationUpdate() {
        return this.splunkDestinationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDeliveryStreamVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedS3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.splunkDestinationUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.currentDeliveryStreamVersionId(), other.currentDeliveryStreamVersionId()) && Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.s3DestinationUpdate(), other.s3DestinationUpdate()) && Objects.equals(this.extendedS3DestinationUpdate(), other.extendedS3DestinationUpdate()) && Objects.equals(this.redshiftDestinationUpdate(), other.redshiftDestinationUpdate()) && Objects.equals(this.elasticsearchDestinationUpdate(), other.elasticsearchDestinationUpdate()) && Objects.equals(this.splunkDestinationUpdate(), other.splunkDestinationUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.currentDeliveryStreamVersionId() != null) {
            sb.append("CurrentDeliveryStreamVersionId: ").append(this.currentDeliveryStreamVersionId()).append(",");
        }
        if (this.destinationId() != null) {
            sb.append("DestinationId: ").append(this.destinationId()).append(",");
        }
        if (this.s3DestinationUpdate() != null) {
            sb.append("S3DestinationUpdate: ").append(this.s3DestinationUpdate()).append(",");
        }
        if (this.extendedS3DestinationUpdate() != null) {
            sb.append("ExtendedS3DestinationUpdate: ").append(this.extendedS3DestinationUpdate()).append(",");
        }
        if (this.redshiftDestinationUpdate() != null) {
            sb.append("RedshiftDestinationUpdate: ").append(this.redshiftDestinationUpdate()).append(",");
        }
        if (this.elasticsearchDestinationUpdate() != null) {
            sb.append("ElasticsearchDestinationUpdate: ").append(this.elasticsearchDestinationUpdate()).append(",");
        }
        if (this.splunkDestinationUpdate() != null) {
            sb.append("SplunkDestinationUpdate: ").append(this.splunkDestinationUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "CurrentDeliveryStreamVersionId": {
                return Optional.of(clazz.cast(this.currentDeliveryStreamVersionId()));
            }
            case "DestinationId": {
                return Optional.of(clazz.cast(this.destinationId()));
            }
            case "S3DestinationUpdate": {
                return Optional.of(clazz.cast(this.s3DestinationUpdate()));
            }
            case "ExtendedS3DestinationUpdate": {
                return Optional.of(clazz.cast(this.extendedS3DestinationUpdate()));
            }
            case "RedshiftDestinationUpdate": {
                return Optional.of(clazz.cast(this.redshiftDestinationUpdate()));
            }
            case "ElasticsearchDestinationUpdate": {
                return Optional.of(clazz.cast(this.elasticsearchDestinationUpdate()));
            }
            case "SplunkDestinationUpdate": {
                return Optional.of(clazz.cast(this.splunkDestinationUpdate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String currentDeliveryStreamVersionId;
        private String destinationId;
        private S3DestinationUpdate s3DestinationUpdate;
        private ExtendedS3DestinationUpdate extendedS3DestinationUpdate;
        private RedshiftDestinationUpdate redshiftDestinationUpdate;
        private ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;
        private SplunkDestinationUpdate splunkDestinationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            this.deliveryStreamName(model.deliveryStreamName);
            this.currentDeliveryStreamVersionId(model.currentDeliveryStreamVersionId);
            this.destinationId(model.destinationId);
            this.s3DestinationUpdate(model.s3DestinationUpdate);
            this.extendedS3DestinationUpdate(model.extendedS3DestinationUpdate);
            this.redshiftDestinationUpdate(model.redshiftDestinationUpdate);
            this.elasticsearchDestinationUpdate(model.elasticsearchDestinationUpdate);
            this.splunkDestinationUpdate(model.splunkDestinationUpdate);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getCurrentDeliveryStreamVersionId() {
            return this.currentDeliveryStreamVersionId;
        }

        @Override
        public final Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
            return this;
        }

        public final void setCurrentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationUpdate.Builder getS3DestinationUpdate() {
            return this.s3DestinationUpdate != null ? this.s3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate;
            return this;
        }

        public final void setS3DestinationUpdate(S3DestinationUpdate.BuilderImpl s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate != null ? s3DestinationUpdate.build() : null;
        }

        public final ExtendedS3DestinationUpdate.Builder getExtendedS3DestinationUpdate() {
            return this.extendedS3DestinationUpdate != null ? this.extendedS3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate;
            return this;
        }

        public final void setExtendedS3DestinationUpdate(ExtendedS3DestinationUpdate.BuilderImpl extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.build() : null;
        }

        public final RedshiftDestinationUpdate.Builder getRedshiftDestinationUpdate() {
            return this.redshiftDestinationUpdate != null ? this.redshiftDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate;
            return this;
        }

        public final void setRedshiftDestinationUpdate(RedshiftDestinationUpdate.BuilderImpl redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate != null ? redshiftDestinationUpdate.build() : null;
        }

        public final ElasticsearchDestinationUpdate.Builder getElasticsearchDestinationUpdate() {
            return this.elasticsearchDestinationUpdate != null ? this.elasticsearchDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate;
            return this;
        }

        public final void setElasticsearchDestinationUpdate(ElasticsearchDestinationUpdate.BuilderImpl elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.build() : null;
        }

        public final SplunkDestinationUpdate.Builder getSplunkDestinationUpdate() {
            return this.splunkDestinationUpdate != null ? this.splunkDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationUpdate(SplunkDestinationUpdate splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate;
            return this;
        }

        public final void setSplunkDestinationUpdate(SplunkDestinationUpdate.BuilderImpl splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate != null ? splunkDestinationUpdate.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    CopyableBuilder<Builder, UpdateDestinationRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder currentDeliveryStreamVersionId(String var1);

        public Builder destinationId(String var1);

        public Builder s3DestinationUpdate(S3DestinationUpdate var1);

        default public Builder s3DestinationUpdate(Consumer<S3DestinationUpdate.Builder> s3DestinationUpdate) {
            return this.s3DestinationUpdate((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().apply(s3DestinationUpdate)).build());
        }

        public Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate var1);

        default public Builder extendedS3DestinationUpdate(Consumer<ExtendedS3DestinationUpdate.Builder> extendedS3DestinationUpdate) {
            return this.extendedS3DestinationUpdate((ExtendedS3DestinationUpdate)((ExtendedS3DestinationUpdate.Builder)ExtendedS3DestinationUpdate.builder().apply(extendedS3DestinationUpdate)).build());
        }

        public Builder redshiftDestinationUpdate(RedshiftDestinationUpdate var1);

        default public Builder redshiftDestinationUpdate(Consumer<RedshiftDestinationUpdate.Builder> redshiftDestinationUpdate) {
            return this.redshiftDestinationUpdate((RedshiftDestinationUpdate)((RedshiftDestinationUpdate.Builder)RedshiftDestinationUpdate.builder().apply(redshiftDestinationUpdate)).build());
        }

        public Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate var1);

        default public Builder elasticsearchDestinationUpdate(Consumer<ElasticsearchDestinationUpdate.Builder> elasticsearchDestinationUpdate) {
            return this.elasticsearchDestinationUpdate((ElasticsearchDestinationUpdate)((ElasticsearchDestinationUpdate.Builder)ElasticsearchDestinationUpdate.builder().apply(elasticsearchDestinationUpdate)).build());
        }

        public Builder splunkDestinationUpdate(SplunkDestinationUpdate var1);

        default public Builder splunkDestinationUpdate(Consumer<SplunkDestinationUpdate.Builder> splunkDestinationUpdate) {
            return this.splunkDestinationUpdate((SplunkDestinationUpdate)((SplunkDestinationUpdate.Builder)SplunkDestinationUpdate.builder().apply(splunkDestinationUpdate)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

