/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequestEntryListCopier;
import software.amazon.awssdk.services.firehose.model.Record;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordBatchRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, PutRecordBatchRequest> {
    private final String deliveryStreamName;
    private final List<Record> records;

    private PutRecordBatchRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.records = builder.records;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public List<Record> records() {
        return this.records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchRequest)) {
            return false;
        }
        PutRecordBatchRequest other = (PutRecordBatchRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.records(), other.records());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "Records": {
                return Optional.of(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private List<Record> records;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchRequest model) {
            this.deliveryStreamName(model.deliveryStreamName);
            this.records(model.records);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copyFromBuilder(records);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutRecordBatchRequest build() {
            return new PutRecordBatchRequest(this);
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    CopyableBuilder<Builder, PutRecordBatchRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

