/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.transform.ExtendedS3DestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExtendedS3DestinationDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ExtendedS3DestinationDescription> {
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationDescription s3BackupDescription;

    private ExtendedS3DestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupDescription = builder.s3BackupDescription;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String prefix() {
        return this.prefix;
    }

    public BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public String compressionFormatString() {
        return this.compressionFormat;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public S3BackupMode s3BackupMode() {
        return S3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeString() {
        return this.s3BackupMode;
    }

    public S3DestinationDescription s3BackupDescription() {
        return this.s3BackupDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationDescription)) {
            return false;
        }
        ExtendedS3DestinationDescription other = (ExtendedS3DestinationDescription)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.compressionFormatString(), other.compressionFormatString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeString(), other.s3BackupModeString()) && Objects.equals(this.s3BackupDescription(), other.s3BackupDescription());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.bucketARN() != null) {
            sb.append("BucketARN: ").append(this.bucketARN()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.bufferingHints() != null) {
            sb.append("BufferingHints: ").append(this.bufferingHints()).append(",");
        }
        if (this.compressionFormatString() != null) {
            sb.append("CompressionFormat: ").append(this.compressionFormatString()).append(",");
        }
        if (this.encryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.encryptionConfiguration()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        if (this.processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.processingConfiguration()).append(",");
        }
        if (this.s3BackupModeString() != null) {
            sb.append("S3BackupMode: ").append(this.s3BackupModeString()).append(",");
        }
        if (this.s3BackupDescription() != null) {
            sb.append("S3BackupDescription: ").append(this.s3BackupDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "BucketARN": {
                return Optional.of(clazz.cast(this.bucketARN()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "BufferingHints": {
                return Optional.of(clazz.cast(this.bufferingHints()));
            }
            case "CompressionFormat": {
                return Optional.of(clazz.cast(this.compressionFormatString()));
            }
            case "EncryptionConfiguration": {
                return Optional.of(clazz.cast(this.encryptionConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.of(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.of(clazz.cast(this.s3BackupModeString()));
            }
            case "S3BackupDescription": {
                return Optional.of(clazz.cast(this.s3BackupDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtendedS3DestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationDescription s3BackupDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationDescription model) {
            this.roleARN(model.roleARN);
            this.bucketARN(model.bucketARN);
            this.prefix(model.prefix);
            this.bufferingHints(model.bufferingHints);
            this.compressionFormat(model.compressionFormat);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupDescription(model.s3BackupDescription);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationDescription.Builder getS3BackupDescription() {
            return this.s3BackupDescription != null ? this.s3BackupDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
            return this;
        }

        public final void setS3BackupDescription(S3DestinationDescription.BuilderImpl s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription != null ? s3BackupDescription.build() : null;
        }

        public ExtendedS3DestinationDescription build() {
            return new ExtendedS3DestinationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExtendedS3DestinationDescription> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().apply(bufferingHints)).build());
        }

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().apply(encryptionConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().apply(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(S3BackupMode var1);

        public Builder s3BackupDescription(S3DestinationDescription var1);

        default public Builder s3BackupDescription(Consumer<S3DestinationDescription.Builder> s3BackupDescription) {
            return this.s3BackupDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().apply(s3BackupDescription)).build());
        }
    }
}

