/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.BufferingHintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BufferingHints
implements StructuredPojo,
ToCopyableBuilder<Builder, BufferingHints> {
    private final Integer sizeInMBs;
    private final Integer intervalInSeconds;

    private BufferingHints(BuilderImpl builder) {
        this.sizeInMBs = builder.sizeInMBs;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    public Integer sizeInMBs() {
        return this.sizeInMBs;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInMBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BufferingHints)) {
            return false;
        }
        BufferingHints other = (BufferingHints)obj;
        return Objects.equals(this.sizeInMBs(), other.sizeInMBs()) && Objects.equals(this.intervalInSeconds(), other.intervalInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sizeInMBs() != null) {
            sb.append("SizeInMBs: ").append(this.sizeInMBs()).append(",");
        }
        if (this.intervalInSeconds() != null) {
            sb.append("IntervalInSeconds: ").append(this.intervalInSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizeInMBs": {
                return Optional.of(clazz.cast(this.sizeInMBs()));
            }
            case "IntervalInSeconds": {
                return Optional.of(clazz.cast(this.intervalInSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BufferingHintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer sizeInMBs;
        private Integer intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BufferingHints model) {
            this.sizeInMBs(model.sizeInMBs);
            this.intervalInSeconds(model.intervalInSeconds);
        }

        public final Integer getSizeInMBs() {
            return this.sizeInMBs;
        }

        @Override
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        public final Integer getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        public BufferingHints build() {
            return new BufferingHints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BufferingHints> {
        public Builder sizeInMBs(Integer var1);

        public Builder intervalInSeconds(Integer var1);
    }
}

